/*
 * Decompiled with CFR 0.152.
 */
public class DataBindTaskStatement
extends DataStatement {
    public static final String BIND_INDEX = "BindIndex";
    public static final String OPEN_PAREN = "(";
    public static final String TASK_VALUE = "TaskValueIndex";
    public static final String COMMA = ",";
    public static final String TASK_NAME = "TaskNameIndex";
    public static final String CLOSE_PAREN = ")";
    public static final String SEMICOLON = ";";
    protected String taskValueToBind = null;
    protected String taskNameToBind = null;
    protected int lineNumberOfTaskValueToBind = -101;

    public boolean hasNullTaskValueToBind() {
        return this.taskValueToBind == null;
    }

    public String getTaskValueToBind() {
        if (this.hasNullTaskValueToBind()) {
            return "";
        }
        return this.taskValueToBind;
    }

    public void setTaskValueToBind(String string) {
        this.taskValueToBind = string;
    }

    public boolean hasNullTaskNameToBind() {
        return this.taskNameToBind == null;
    }

    public String getTaskNameToBind() {
        if (this.hasNullTaskNameToBind()) {
            return this.getTaskValueToBind();
        }
        return this.taskNameToBind;
    }

    public void setTaskNameToBind(String string) {
        this.taskNameToBind = string;
    }

    public void setLineNumberOfTaskValueToBind(int n) {
        this.lineNumberOfTaskValueToBind = n;
    }

    public int getLineNumberOfTaskValueToBind() {
        return this.lineNumberOfTaskValueToBind;
    }

    public boolean hasValidLineNumberOfTaskValueToBind() {
        return DataComponent.isValidLineNumber(this.getLineNumberOfTaskValueToBind());
    }

    public void generate(DataDestination dataDestination, int n) {
        this.warnIfInvalidObjectSubset(n, "generate");
        this.initializeGenerateSubcomponentIndex();
        this.generateLabels(dataDestination, n, BIND_INDEX);
        this.generateSubcomponents(BIND_INDEX, dataDestination, n, false);
        if (this.isCxxSubset(n)) {
            dataDestination.setNewlineText("    // ");
            dataDestination.write("    // ");
        }
        dataDestination.write("TDL_BIND");
        this.generateSubcomponents(OPEN_PAREN, dataDestination, n, false);
        dataDestination.write(OPEN_PAREN);
        this.generateSubcomponents(TASK_VALUE, dataDestination, n, false);
        dataDestination.write(this.getTaskValueToBind());
        if (!this.hasNullTaskNameToBind()) {
            this.generateSubcomponents(COMMA, dataDestination, n, false);
            dataDestination.write(COMMA);
            this.generateSubcomponents(TASK_NAME, dataDestination, n, false);
            dataDestination.write(this.getTaskNameToBind());
        }
        this.generateSubcomponents(CLOSE_PAREN, dataDestination, n, false);
        dataDestination.write(CLOSE_PAREN);
        this.generateSubcomponents(SEMICOLON, dataDestination, n, false);
        dataDestination.write(SEMICOLON);
        this.generateAllRemainingSubcomponents(dataDestination, n, false);
        if (this.isCxxSubset(n)) {
            dataDestination.clearNewlineText();
            dataDestination.write("\n");
            this.generateCxx(dataDestination, n);
        }
    }

    public void generateCxx(DataDestination dataDestination, int n) {
        int n2 = 0;
        dataDestination.setUsingTdlFileName(false);
        dataDestination.write("\n");
        dataDestination.write("_TDL_SpawnedTasks");
        dataDestination.write(" . ");
        dataDestination.write("bindTCMTask");
        dataDestination.write(" ( ");
        if (dataDestination.getEnableLineMacros()) {
            n2 = dataDestination.indentToCurrentColumn();
            dataDestination.setUsingTdlFileName(true);
            dataDestination.makeNextLineNumber(this.getLineNumberOfTaskValueToBind());
            dataDestination.write("\n");
        }
        dataDestination.write(this.getTaskValueToBind());
        dataDestination.write(" , ");
        if (dataDestination.getEnableLineMacros()) {
            dataDestination.setUsingTdlFileName(false);
            dataDestination.write("\n\"");
            dataDestination.removeIndent(n2);
        } else {
            dataDestination.write("\"");
        }
        dataDestination.write(this.getTaskNameToBind());
        dataDestination.write("\" );\n");
    }

    public boolean isSpawnRelatedStatement() {
        return true;
    }
}

