/*
 * Decompiled with CFR 0.152.
 */
public class DetailedParseException
extends Exception {
    public static final int UNKNOWN_VALUE = -1;
    protected Throwable originalException;

    public DetailedParseException(ParseException parseException) {
        this.originalException = parseException;
        ++parseException.currentToken.next.beginLine;
    }

    public DetailedParseException(TokenMgrError tokenMgrError) {
        this.originalException = tokenMgrError;
    }

    public DetailedParseException(DetailedParseException detailedParseException) {
        this.originalException = detailedParseException;
    }

    public DetailedParseException(String string) {
        super(string);
        this.originalException = null;
    }

    public DetailedParseException(Throwable throwable) {
        this.originalException = throwable;
    }

    public Throwable getOriginalException() {
        return this.originalException;
    }

    public boolean getHasErrorLocation() {
        return this.getOriginalException() instanceof ParseException && ((ParseException)this.getOriginalException()).currentToken != null;
    }

    public int getErrorLineStart() {
        if (this.getHasErrorLocation()) {
            return ((ParseException)this.getOriginalException()).currentToken.next.beginLine;
        }
        return -1;
    }

    public int getErrorColumnStart() {
        if (this.getHasErrorLocation()) {
            return ((ParseException)this.getOriginalException()).currentToken.next.beginColumn;
        }
        return -1;
    }

    public int getErrorLength() {
        if (this.getHasErrorLocation()) {
            return ((ParseException)this.getOriginalException()).currentToken.next.image.length();
        }
        return -1;
    }

    public String getMessage() {
        if (this.getOriginalException() == null) {
            return super.getMessage();
        }
        return this.getOriginalException().getMessage();
    }

    public String getLocalizedMessage() {
        return this.getOriginalException().getLocalizedMessage();
    }

    public String toString() {
        if (this.getOriginalException() == null) {
            return this.getMessage();
        }
        if (this.getOriginalException() instanceof ParseException) {
            return this.getOriginalException().toString();
        }
        if (this.getOriginalException() instanceof TokenMgrError) {
            return "Unknown Token Manager Error:\n\n" + this.getOriginalException().toString();
        }
        if (this.getOriginalException() instanceof DetailedParseException) {
            return this.getOriginalException().toString();
        }
        if (this.getOriginalException() instanceof Throwable) {
            return this.getOriginalException().toString();
        }
        return "Unknown Error:\n\n" + this.getOriginalException().toString();
    }

    public String toClippedString() {
        return this.toClippedString(30);
    }

    public String toClippedString(int n) {
        String string = this.toString();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if ((n2 = string.indexOf("\n", n2)) == -1) {
                return string;
            }
            ++n2;
            ++n3;
        }
        return string.substring(0, n2) + ".........................";
    }
}

