/*
 * Decompiled with CFR 0.152.
 */
public class DataSwitchStatement
extends DataSelectionStatement {
    public static final String SWITCH = "switch";
    public static final String OPEN_PAREN = "(";
    public static final String CLOSE_PAREN = ")";
    public static final String EXPRESSION_INDEX = "ExpressionIndex";
    public static final String STATEMENT_INDEX = "StatementIndex";
    public static final String SEMICOLON = ";";
    public static final int SWITCH_EXPRESSION_ONLY = 5;
    protected DataExpression expression = null;
    private DataStatement lastStatementWithCaseOrDefaultLabel;
    private boolean hasFoundSpawn;

    public DataExpression getExpression() {
        return this.expression;
    }

    public void setExpression(DataExpression dataExpression) {
        if (this.expression != null) {
            this.expression.setParent(null);
        }
        this.expression = dataExpression;
        if (this.expression != null) {
            this.expression.setParent(this);
        }
    }

    public boolean hasSubcomponentFraction(String string) {
        return super.hasSubcomponentFraction(string) || this.getExpression() != null && this.getExpression().hasSubcomponentFraction(string);
    }

    public void runOnSubcomponentFraction(String string, RunOnSubcomponentInterface runOnSubcomponentInterface, Object object) {
        super.runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        if (this.getExpression() != null) {
            this.getExpression().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
    }

    public String getWarnString(int n) {
        return super.getWarnString(n) + " or DataSwitchStatement.SWITCH_EXPRESSION_ONLY (" + 5 + CLOSE_PAREN;
    }

    public boolean isValidObjectSubset(int n) {
        if (n == 5) {
            return true;
        }
        return super.isValidObjectSubset(n);
    }

    public boolean isValid(int n) {
        if (n == 5) {
            return this.getExpression() != null;
        }
        if (this.getExpression() == null || this.getStatement() == null) {
            return false;
        }
        return super.isValid(n);
    }

    public void generateExpression(DataDestination dataDestination, int n, boolean bl) {
        boolean bl2 = bl;
        boolean bl3 = bl;
        if (this.getExpression() != null) {
            if (this.getExpression().hasLeadingWhitespaceSubcomponent()) {
                bl2 = false;
            }
            if (this.getExpression().hasTrailingWhitespaceSubcomponent()) {
                bl3 = false;
            }
        }
        this.initializeGenerateSubcomponentIndex(OPEN_PAREN);
        this.generateSubcomponents(EXPRESSION_INDEX, dataDestination, n, bl2);
        if (this.getExpression() != null) {
            this.getExpression().generate(dataDestination, n);
        }
        this.generateSubcomponents(CLOSE_PAREN, dataDestination, n, bl3);
    }

    public void generate(DataDestination dataDestination, int n) {
        this.warnIfInvalidObjectSubset(n, "generate");
        if (n == 5) {
            this.generateExpression(dataDestination, 0, false);
            return;
        }
        this.initializeGenerateSubcomponentIndex();
        this.generateLabels(dataDestination, n, SWITCH);
        this.generateSubcomponents(SWITCH, dataDestination, n, false);
        dataDestination.write(SWITCH);
        this.generateSubcomponents(OPEN_PAREN, dataDestination, n, false);
        dataDestination.write(OPEN_PAREN);
        this.generateExpression(dataDestination, n, true);
        dataDestination.write(CLOSE_PAREN);
        this.generateSubcomponents(STATEMENT_INDEX, dataDestination, n, false);
        if (this.getStatement() != null) {
            if (this.isCxxSubset(n)) {
                this.addSpawnDestroys();
            }
            dataDestination.addSecondaryIndent(DataComponent.STANDARD_INDENT);
            this.getStatement().generate(dataDestination, n);
            dataDestination.removeSecondaryIndent(DataComponent.STANDARD_INDENT);
            if (this.isCxxSubset(n)) {
                this.removeSpawnDestroys(this.getStatement());
                String string = this.getStatement().getSpawnDestroyClause(true);
                if (!DataComponent.isEmptyString(string)) {
                    dataDestination.setUsingTdlFileName(false);
                    dataDestination.write("\n");
                }
                dataDestination.enableSecondaryIndent();
                dataDestination.write(string);
                dataDestination.disableSecondaryIndent();
            }
        } else {
            dataDestination.write(SEMICOLON);
        }
        this.generateAllRemainingSubcomponents(dataDestination, n, false);
    }

    protected void addSpawnDestroys() {
        String string;
        this.lastStatementWithCaseOrDefaultLabel = null;
        this.hasFoundSpawn = false;
        if (this.getStatement() != null) {
            this.privateAddSpawnDestroys(this.getStatement(), false);
        }
        if (this.hasFoundSpawn && this.lastStatementWithCaseOrDefaultLabel != null && !DataComponent.isEmptyString(string = this.getSpawnDestroyClause(null, this.lastStatementWithCaseOrDefaultLabel, true))) {
            this.lastStatementWithCaseOrDefaultLabel.setPostLabelString("\n" + string);
        }
    }

    protected void privateAddSpawnDestroys(DataStatement dataStatement, boolean bl) {
        if (dataStatement.hasCaseOrDefaultLabel() && !bl) {
            String string;
            if (this.hasFoundSpawn && this.lastStatementWithCaseOrDefaultLabel != null && !DataComponent.isEmptyString(string = this.getSpawnDestroyClause(null, this.lastStatementWithCaseOrDefaultLabel, true))) {
                this.lastStatementWithCaseOrDefaultLabel.setPostLabelString("\n" + string);
            }
            this.lastStatementWithCaseOrDefaultLabel = dataStatement;
            this.hasFoundSpawn = false;
        }
        if (dataStatement instanceof DataSpawnTask) {
            this.hasFoundSpawn = true;
        }
        if (dataStatement instanceof DataSwitchStatement) {
            bl = true;
        }
        int n = 0;
        while (n < dataStatement.getChildStatementCount()) {
            this.privateAddSpawnDestroys(dataStatement.getChildStatement(n), bl);
            ++n;
        }
    }

    protected void removeSpawnDestroys(DataStatement dataStatement) {
        if (dataStatement != this) {
            dataStatement.setPostLabelString(null);
        }
        if (!(dataStatement instanceof DataSwitchStatement)) {
            int n = 0;
            while (n < dataStatement.getChildStatementCount()) {
                this.removeSpawnDestroys(dataStatement.getChildStatement(n));
                ++n;
            }
        }
    }
}

