/*
 * Decompiled with CFR 0.152.
 */
public class DataSpawnTask
extends DataStatement
implements DataValidateCode,
DataConstrainedObject {
    public static final String SPAWN = "SPAWN";
    public static final String TASK_NAME_INDEX = "taskNameIndex";
    public static final String OPEN_PAREN = "(";
    public static final String CLOSE_PAREN = ")";
    public static final String COMMA = ",";
    public static final String WITH = "WITH";
    public static final String SEMICOLON = ";";
    public static final int TASK_ONLY = 3;
    public static final int CONSTRAINTS_ONLY = 2;
    protected static int ARBITRARY_SUBTASK_INDEX = 0;
    protected static DataConstraint WAIT_CONSTRAINT = new DataConstraint(7);
    protected String taskname = "";
    protected DataVector arguments = new DataVector();
    protected DataVector constraints = new DataVector();
    protected int extraIndent = 0;

    public static synchronized int getArbitrarySubTaskIndex() {
        return ++ARBITRARY_SUBTASK_INDEX;
    }

    public String getTaskName() {
        return this.taskname;
    }

    public void setTaskName(String string) {
        this.taskname = string;
    }

    public DataVector getArguments() {
        return this.arguments;
    }

    public DataVector getConstraints() {
        return this.constraints;
    }

    public int getConstraintCount() {
        return this.getConstraints().count();
    }

    public void addArgument(DataExpression dataExpression) {
        this.getArguments().addElement(dataExpression);
        dataExpression.setParent(this);
    }

    public void addArgument(DataExpression dataExpression, int n) {
        this.getArguments().insertElementAt(dataExpression, n);
        dataExpression.setParent(this);
    }

    public void addArgument(String string, int n) {
        DataExpression dataExpression = new DataExpression();
        dataExpression.addSubcomponent(string);
        this.addArgument(dataExpression, n);
    }

    public void removeArgument(int n) {
        this.getArguments().removeElementAt(n);
    }

    public DataExpression getArgument(int n) {
        if (n >= 0 && n < this.getArguments().count()) {
            return (DataExpression)this.getArguments().elementAt(n);
        }
        return null;
    }

    public void addConstraint(DataConstraint dataConstraint) {
        this.getConstraints().addElement(dataConstraint);
        dataConstraint.setParent(this);
    }

    public DataConstraint getConstraint(int n) {
        if (n >= 0 && n < this.getConstraints().count()) {
            return (DataConstraint)this.getConstraints().elementAt(n);
        }
        return null;
    }

    public int getExtraIndent() {
        return this.extraIndent;
    }

    public void setExtraIndent(int n) {
        this.extraIndent = n;
    }

    public boolean hasName(String string) {
        if (this.getTaskName() != null && this.getTaskName().equals(string)) {
            return true;
        }
        return super.hasName(string);
    }

    public boolean hasSubcomponentFraction(String string) {
        if (super.hasSubcomponentFraction(string)) {
            return true;
        }
        int n = 0;
        while (n < this.getArguments().count()) {
            if (this.getArgument(n).hasSubcomponentFraction(string)) {
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < this.getConstraintCount()) {
            if (this.getConstraint(n).hasSubcomponentFraction(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void runOnSubcomponentFraction(String string, RunOnSubcomponentInterface runOnSubcomponentInterface, Object object) {
        super.runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        int n = 0;
        while (n < this.getArguments().count()) {
            this.getArgument(n).runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
            ++n;
        }
        n = 0;
        while (n < this.getConstraintCount()) {
            this.getConstraint(n).runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
            ++n;
        }
    }

    public void validateExternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        int n2 = 0;
        while (n2 < this.getConstraints().count()) {
            this.getConstraint(n2).validateExternalCode(n, dataValidateCodeReturnValue);
            ++n2;
        }
        DataStatement.validateAnyOverridenConstraints(this, dataValidateCodeReturnValue);
    }

    public void validateInternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        super.validateInternalCode(n, dataValidateCodeReturnValue);
        int n2 = 0;
        while (n2 < this.getConstraints().count()) {
            this.getConstraint(n2).validateInternalCode(n, dataValidateCodeReturnValue);
            if (this.getConstraint(n2).getConstraintType() == 6) {
                dataValidateCodeReturnValue.addWarning(this.getConstraint(n2)).write("PARALLEL constraint in a SPAWN statement WITH clause is meaningless.\n");
            }
            ++n2;
        }
        DataStatement.validateInternalConstrainedObject(n, dataValidateCodeReturnValue, this);
        DataStatement.validateAnyOverridenConstraints(this, dataValidateCodeReturnValue);
    }

    public String getWarnString(int n) {
        return super.getWarnString(n) + " or DataSpawnTask.TASK_ONLY (" + 3 + ") or DataSpawnTask.CONSTRAINTS_ONLY (" + 2 + CLOSE_PAREN;
    }

    public boolean isValidObjectSubset(int n) {
        if (n == 3 || n == 2) {
            return true;
        }
        return super.isValidObjectSubset(n);
    }

    public void generateTask(DataDestination dataDestination, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n2 = 0;
        boolean bl6 = false;
        if (bl2) {
            this.initializeGenerateSubcomponentIndex(SPAWN);
            this.generateSubcomponents(TASK_NAME_INDEX, dataDestination, n, bl);
        } else {
            this.initializeGenerateSubcomponentIndex(TASK_NAME_INDEX);
        }
        dataDestination.write(this.getTaskName());
        this.generateSubcomponents(OPEN_PAREN, dataDestination, n, false);
        dataDestination.write(OPEN_PAREN);
        if (bl3) {
            if (bl4) {
                dataDestination.addIndent(DataComponent.STANDARD_INDENT);
            } else {
                dataDestination.write(" ");
                n2 = dataDestination.indentToCurrentColumn();
            }
        }
        int n3 = 0;
        while (n3 < this.getArguments().count()) {
            if (bl5 && this.getArgument(n3).hasValidLineNumber() && dataDestination.getEnableLineMacros()) {
                dataDestination.setUsingTdlFileName(true);
                dataDestination.makeNextLineNumber(this.getArgument(n3).getLineNumber() + (bl3 ? this.getArgument(n3).countLeadingSubcomponentNewlines() : 0));
                dataDestination.write("\n");
                bl6 = true;
            } else if (bl3 && (n3 > 0 || bl4)) {
                dataDestination.write("\n");
            }
            if (bl3) {
                dataDestination.setStripLeadingWhitespace();
                dataDestination.setPersistentlyStripLeadingSpaces(true);
            }
            this.getArgument(n3).generate(dataDestination, n);
            if (bl3) {
                dataDestination.setPersistentlyStripLeadingSpaces(false);
            }
            if (n3 + 1 < this.getArguments().count()) {
                dataDestination.write(COMMA);
            }
            ++n3;
        }
        if (bl6) {
            dataDestination.setUsingTdlFileName(false);
            dataDestination.write("\n");
        }
        this.generateSubcomponents(CLOSE_PAREN, dataDestination, n, false);
        dataDestination.write(CLOSE_PAREN);
        if (bl3) {
            if (bl4) {
                dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            } else {
                dataDestination.removeIndent(n2);
            }
        }
    }

    public void generateConstraints(DataDestination dataDestination, int n) {
        int n2 = 0;
        while (n2 < this.getConstraints().count()) {
            this.getConstraint(n2).generate(dataDestination, n);
            if (n2 + 1 < this.getConstraints().count()) {
                dataDestination.write(COMMA);
            }
            ++n2;
        }
    }

    public void generate(DataDestination dataDestination, int n) {
        dataDestination.addIndent(this.getExtraIndent());
        this.warnIfInvalidObjectSubset(n, "generate");
        if (n == 3) {
            this.generateTask(dataDestination, 0, false, true, false, false, this.isCxxSubset(n));
            dataDestination.removeIndent(this.getExtraIndent());
            return;
        }
        if (n == 2) {
            this.generateConstraints(dataDestination, 0);
            dataDestination.removeIndent(this.getExtraIndent());
            return;
        }
        this.initializeGenerateSubcomponentIndex();
        this.generateLabels(dataDestination, n, this.isCxxSubset(n) && this.getParentTaskDefinition() != null ? 100 : 0, SPAWN);
        this.generateSubcomponents(SPAWN, dataDestination, n, false);
        if (this.isCxxSubset(n)) {
            dataDestination.setNewlineText("    // ");
            dataDestination.write("    // ");
        }
        dataDestination.write(SPAWN);
        this.generateTask(dataDestination, n, true, true, false, false, false);
        if (this.getConstraints().count() > 0) {
            this.generateSubcomponents(WITH, dataDestination, n, true);
            dataDestination.write(WITH);
            this.generateConstraints(dataDestination, 0);
        }
        this.generateSubcomponents(SEMICOLON, dataDestination, n, false);
        dataDestination.write(SEMICOLON);
        this.generateAllRemainingSubcomponents(dataDestination, n, false);
        if (this.isCxxSubset(n)) {
            dataDestination.clearNewlineText();
            dataDestination.write("\n");
            this.generateCxx(dataDestination, n);
        }
        dataDestination.removeIndent(this.getExtraIndent());
    }

    public void generateCxx(DataDestination dataDestination, int n) throws CompilationException {
        DataConstraint dataConstraint = null;
        int n2 = DataConstraint.getLastIndexOfConstraintOfType(25, this);
        int n3 = DataConstraint.getLastIndexOfConstraintOfType(26, this);
        dataDestination.setUsingTdlFileName(false);
        dataDestination.write("\n");
        DataTaskDefinition dataTaskDefinition = this.getParentTaskDefinition();
        if (dataTaskDefinition == null) {
            int n4 = 0;
            while (n4 < this.getConstraints().count()) {
                if (this.getConstraint(n4).getHasNonStandardEventTagTask()) {
                    throw new CompilationException("Internal Error in [DataSpawnTask:generateCxx]:  Spawn statement is not contained in a task.  Unable to satisfy constraint \"" + this.getConstraint(n4).toString() + "\".");
                }
                ++n4;
            }
            DataSpawnTask.generateCxxOutsideOfTask(dataDestination, n, this);
            return;
        }
        String string = dataTaskDefinition.getIdentifierForSubtask(this);
        dataDestination.enableSecondaryIndent();
        dataDestination.write("_TDL_SpawnedTasks");
        dataDestination.write(" ");
        dataDestination.write(". ");
        dataDestination.write("startInvokingSpawn");
        dataDestination.write(" ( ");
        int n5 = dataDestination.indentToCurrentColumn();
        dataDestination.write("\"");
        dataDestination.write(string);
        dataDestination.write("\"");
        if (n2 >= 0) {
            dataDestination.write(",\n");
            this.getConstraint(n2).generateCxxTaskInternal(dataDestination);
        }
        if (n3 >= 0) {
            dataDestination.setUsingTdlFileName(true);
            dataDestination.makeNextLineNumber(this.getConstraint(n3).getTcmTaskTreeParentExpression());
            dataDestination.write(",\n");
            this.getConstraint(n3).getTcmTaskTreeParentExpression().generate(dataDestination, 0);
            dataDestination.setUsingTdlFileName(false);
        }
        dataDestination.removeIndent(n5);
        dataDestination.write(" );\n");
        dataDestination.write("_TDL_SpawnedTasks");
        dataDestination.write(" ");
        int n6 = dataDestination.indentToCurrentColumn();
        dataDestination.write(". ");
        dataDestination.write("doSetAction");
        dataDestination.write(" ( ");
        dataDestination.write("_TDL_CreateAction_");
        dataDestination.write(this.getTaskName());
        dataDestination.write(" ( ");
        n5 = dataDestination.indentToCurrentColumn();
        dataDestination.write("* ( ");
        dataDestination.write("_TDL_SpawnedTasks");
        dataDestination.write(" . ");
        dataDestination.write("getCurrentTask");
        dataDestination.write("() )");
        int n7 = 0;
        while (n7 < this.getArguments().count()) {
            dataDestination.setUsingTdlFileName(true);
            dataDestination.makeNextLineNumber(this.getArgument(n7).getLineNumber() + this.getArgument(n7).countLeadingSubcomponentNewlines());
            dataDestination.write(",\n");
            dataDestination.setStripLeadingWhitespace();
            dataDestination.setPersistentlyStripLeadingSpaces(true);
            this.getArgument(n7).generate(dataDestination, n);
            dataDestination.setPersistentlyStripLeadingSpaces(false);
            ++n7;
        }
        dataDestination.setUsingTdlFileName(false);
        dataDestination.write(" ) )\n");
        dataDestination.removeIndent(n5);
        n7 = 0;
        while (n7 < this.getConstraints().count()) {
            if (DataConstraint.getShouldConstraintBeCxxGenerated(this.getConstraint(n7), this.getConstraints(), false, true)) {
                dataDestination.write(". ");
                dataDestination.write("doApplyConstraint");
                dataDestination.write(" ( ");
                this.getConstraint(n7).generateCxxTaskInternal(dataDestination);
                dataDestination.write(" )\n");
            }
            ++n7;
        }
        dataDestination.write(". ");
        dataDestination.write("doInsertSpawn");
        dataDestination.write(" ()\n");
        n7 = 0;
        while (n7 < this.getConstraints().count()) {
            if (DataConstraint.getShouldConstraintBeCxxGenerated(this.getConstraint(n7), this.getConstraints(), true, true)) {
                if (this.getConstraint(n7).getConstraintType() == 7) {
                    if (dataConstraint == null) {
                        dataConstraint = this.getConstraint(n7);
                    }
                } else {
                    dataDestination.write(". ");
                    dataDestination.write("doApplyConstraint");
                    dataDestination.write(" ( ");
                    this.getConstraint(n7).generateCxxTaskInternal(dataDestination);
                    dataDestination.write(" )\n");
                }
            }
            ++n7;
        }
        if (dataConstraint != null) {
            dataDestination.write(". ");
            dataDestination.write("doApplyConstraint");
            dataDestination.write(" ( ");
            dataConstraint.generateCxxTaskInternal(dataDestination);
            dataDestination.write(" )\n");
        }
        dataDestination.write(". ");
        dataDestination.write("finishInvokingSpawn");
        dataDestination.removeIndent(n6);
        dataDestination.write("();\n");
        dataDestination.disableSecondaryIndent();
    }

    public static void generateCxxOutsideOfTask(DataDestination dataDestination, int n, DataSpawnTask dataSpawnTask) {
        DataSpawnTask.privateGenerateCxxOutsideOfTask(dataDestination, n, dataSpawnTask);
    }

    public static void generateCxxOutsideOfTask(DataDestination dataDestination, int n, DataTaskDefinition dataTaskDefinition) {
        DataSpawnTask.privateGenerateCxxOutsideOfTask(dataDestination, n, dataTaskDefinition);
    }

    protected static void privateGenerateCxxOutsideOfTask(DataDestination dataDestination, int n, DataComponent dataComponent) {
        int n2;
        String string;
        String string2;
        String string3;
        String string4;
        boolean bl;
        DataConstraint dataConstraint = null;
        DataSpawnTask dataSpawnTask = null;
        DataTaskDefinition dataTaskDefinition = null;
        if (dataComponent instanceof DataSpawnTask) {
            bl = true;
            dataSpawnTask = (DataSpawnTask)dataComponent;
        } else if (dataComponent instanceof DataTaskDefinition) {
            bl = false;
            dataTaskDefinition = (DataTaskDefinition)dataComponent;
        } else {
            System.err.println("[DataSpawnTask:privateGenerateCxxOutsideOfTask]  Programmer Error:  theTaskSource is not a DataSpawnTask or a DataTaskDefinition. Aborting...");
            return;
        }
        if (bl) {
            string4 = dataSpawnTask.getTaskName();
            string3 = "_TDL_arbitrarySubTask_" + DataSpawnTask.getArbitrarySubTaskIndex();
            string2 = "\"[:'" + string4 + "' - " + string3 + "]\"";
            string = "";
            dataDestination.write("{\n");
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        } else {
            string4 = dataTaskDefinition.getTaskName();
            string3 = "spawnChild";
            string2 = "\"[_TDL_SpawnAndWait_" + string4 + "]\"";
            string = "returnValue = ";
            dataDestination.write("TCM_Return_Type");
            dataDestination.write("    ");
            dataDestination.write("returnValue");
            dataDestination.write(" = ");
            dataDestination.write("TCM_Error");
            dataDestination.write(";\n");
        }
        dataDestination.write("TCM_Task_Tree_Ref");
        dataDestination.write("  ");
        dataDestination.write(string3);
        dataDestination.write(" = ");
        dataDestination.write("_TDL_Allocate_");
        dataDestination.write(string4);
        int n3 = bl ? DataConstraint.getLastIndexOfConstraintOfType(28, dataSpawnTask) : -1;
        if (n3 >= 0) {
            dataDestination.write(" ( ");
            dataDestination.setUsingTdlFileName(true);
            dataDestination.makeNextLineNumber(dataSpawnTask.getConstraint(n3).getTcmTaskTreeNameExpression());
            if (dataDestination.getEnableLineMacros()) {
                dataDestination.write("\n");
            }
            dataSpawnTask.getConstraint(n3).getTcmTaskTreeNameExpression().generate(dataDestination, 0);
            dataDestination.setUsingTdlFileName(false);
            dataDestination.write(" );\n");
        } else {
            dataDestination.write(" ( \"");
            dataDestination.write(string4);
            if (bl) {
                dataDestination.write("-outsideTask\" );\n");
            } else {
                dataDestination.write("-auto,wait\" );\n");
            }
        }
        if (bl) {
            n2 = 0;
            while (n2 < dataSpawnTask.getConstraintCount()) {
                dataSpawnTask.getConstraint(n2).generateCxxExternalSubtaskDeclarations(dataDestination, false);
                ++n2;
            }
        }
        if (bl) {
            DataLabelStatement dataLabelStatement = dataSpawnTask.getLabel();
            while (dataLabelStatement != null) {
                if (dataLabelStatement.hasId()) {
                    dataDestination.write(dataLabelStatement.getId());
                    dataDestination.write(" = ");
                    dataDestination.write(string3);
                    dataDestination.write(";\n");
                }
                dataLabelStatement = dataLabelStatement.getLabel();
            }
            n2 = 0;
            while (n2 < dataSpawnTask.getConstraints().count()) {
                if (dataSpawnTask.getConstraint(n2).getConstraintType() == 27) {
                    dataDestination.setStripLeadingWhitespace();
                    dataDestination.setPersistentlyStripLeadingSpaces(true);
                    dataSpawnTask.getConstraint(n2).getTdlRefInExpression().generate(dataDestination, n);
                    dataDestination.setPersistentlyStripLeadingSpaces(false);
                    dataDestination.write(" = ");
                    dataDestination.write(string3);
                    dataDestination.write(";\n");
                }
                if (dataSpawnTask.getConstraint(n2).getCxxExternalSubtaskName() != null) {
                    dataLabelStatement = dataSpawnTask.getConstraint(n2).getCxxExternalSubtaskDeclarationLabel();
                    while (dataLabelStatement != null) {
                        if (dataLabelStatement.hasId()) {
                            dataDestination.write(dataLabelStatement.getId());
                            dataDestination.write(" = ");
                            dataDestination.write(dataSpawnTask.getConstraint(n2).getCxxExternalSubtaskName());
                            dataDestination.write(";\n");
                        }
                        dataLabelStatement = dataLabelStatement.getLabel();
                    }
                }
                ++n2;
            }
        }
        dataDestination.write("\nif (");
        int n4 = dataDestination.indentToCurrentColumn();
        dataDestination.write("   ");
        dataDestination.write("TDL::verifyAllocation");
        dataDestination.write(" ( ");
        int n5 = dataDestination.indentToCurrentColumn();
        dataDestination.write(string2);
        dataDestination.write(",\n");
        dataDestination.write(string3);
        dataDestination.write(" )\n");
        dataDestination.removeIndent(n5);
        dataDestination.write("\n&& ");
        dataDestination.write("TDL::verifySetAction ");
        dataDestination.write(" ( ");
        n5 = dataDestination.indentToCurrentColumn();
        dataDestination.write(string2);
        dataDestination.write(",\n");
        dataDestination.write(string);
        dataDestination.write("TCM_SetActualAction");
        dataDestination.write(" ( ");
        dataDestination.removeIndent(n5);
        n5 = dataDestination.indentToCurrentColumn();
        dataDestination.write(string3);
        dataDestination.write(" ,\n");
        dataDestination.write("_TDL_CreateAction_");
        dataDestination.write(string4);
        dataDestination.write(" ( ");
        dataDestination.removeIndent(n5);
        n5 = dataDestination.indentToCurrentColumn();
        dataDestination.write(string3);
        if (bl) {
            n2 = 0;
            while (n2 < dataSpawnTask.getArguments().count()) {
                dataDestination.setUsingTdlFileName(true);
                dataDestination.makeNextLineNumber(dataSpawnTask.getArgument(n2).getLineNumber() + dataSpawnTask.getArgument(n2).countLeadingSubcomponentNewlines());
                dataDestination.write(",\n");
                dataDestination.setStripLeadingWhitespace();
                dataDestination.setPersistentlyStripLeadingSpaces(true);
                dataSpawnTask.getArgument(n2).generate(dataDestination, n);
                dataDestination.setPersistentlyStripLeadingSpaces(false);
                ++n2;
            }
            dataDestination.setUsingTdlFileName(false);
        } else {
            n2 = 0;
            while (n2 < dataTaskDefinition.getTaskArgumentCount()) {
                dataDestination.write(",\n");
                dataDestination.setStripLeadingWhitespace();
                dataDestination.write(dataTaskDefinition.getTaskArgument(n2).getArgumentName());
                ++n2;
            }
        }
        dataDestination.write(" ) ) )\n");
        dataDestination.removeIndent(n5);
        if (bl) {
            n2 = 0;
            while (n2 < dataSpawnTask.getConstraints().count()) {
                if (DataConstraint.getShouldConstraintBeCxxGenerated(dataSpawnTask.getConstraint(n2), dataSpawnTask.getConstraints(), false, false)) {
                    dataSpawnTask.getConstraint(n2).generateCxxTaskExternal(dataDestination, string2, string3, string, true, false);
                }
                ++n2;
            }
        }
        dataDestination.write("\n&& ");
        dataDestination.write("TDL::verifyInsertNode");
        dataDestination.write(" ( ");
        n5 = dataDestination.indentToCurrentColumn();
        dataDestination.write(string2);
        dataDestination.write(",\n");
        dataDestination.write(string);
        dataDestination.write("TCM_InsertNode");
        dataDestination.write(" ( ");
        dataDestination.removeIndent(n5);
        n5 = dataDestination.indentToCurrentColumn();
        if (bl) {
            int n6 = DataConstraint.getLastIndexOfConstraintOfType(26, dataSpawnTask);
            if (n6 >= 0) {
                if (dataDestination.getEnableLineMacros()) {
                    dataDestination.setUsingTdlFileName(true);
                    dataDestination.makeNextLineNumber(dataSpawnTask.getConstraint(n6).getTcmTaskTreeParentExpression());
                    dataDestination.write("\n");
                }
                dataSpawnTask.getConstraint(n6).getTcmTaskTreeParentExpression().generate(dataDestination, 0);
                if (dataDestination.getEnableLineMacros()) {
                    dataDestination.setUsingTdlFileName(false);
                }
            } else {
                dataDestination.write(DataComponent.CXX_TCM_ROOT_NODE);
            }
        } else {
            dataDestination.write("theParentTaskTreeRef");
        }
        dataDestination.write(",\n");
        dataDestination.write(string3);
        dataDestination.write(",\n");
        if (bl) {
            dataDestination.write("TRUE");
        } else {
            dataDestination.write("FALSE");
        }
        dataDestination.write(" ) )\n");
        dataDestination.removeIndent(n5);
        if (bl) {
            n2 = 0;
            while (n2 < dataSpawnTask.getConstraints().count()) {
                if (DataConstraint.getShouldConstraintBeCxxGenerated(dataSpawnTask.getConstraint(n2), dataSpawnTask.getConstraints(), true, false)) {
                    if (dataSpawnTask.getConstraint(n2).getConstraintType() == 7) {
                        if (dataConstraint == null) {
                            dataConstraint = dataSpawnTask.getConstraint(n2);
                        }
                    } else {
                        dataSpawnTask.getConstraint(n2).generateCxxTaskExternal(dataDestination, string2, string3, string, true, false);
                    }
                }
                ++n2;
            }
            if (dataConstraint != null) {
                dataConstraint.generateCxxTaskExternal(dataDestination, string2, string3, string, true, false);
            }
        }
        if (dataConstraint == null && !bl) {
            WAIT_CONSTRAINT.generateCxxTaskExternal(dataDestination, string2, string3, string, true, false);
        }
        dataDestination.write(CLOSE_PAREN);
        dataDestination.removeIndent(n4);
        dataDestination.write("\n{\n");
        dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        dataDestination.write("; /* Null Statement!  (Task has been successfully SPAWN'ed) */\n");
        dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
        dataDestination.write("}\n");
        if (bl) {
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("}\n");
        } else {
            dataDestination.write("\nreturn ");
            dataDestination.write("returnValue");
            dataDestination.write(";\n");
        }
    }

    public boolean isSpawnRelatedStatement() {
        return true;
    }

    public int getChildStatementCount() {
        return super.getChildStatementCount() + this.getConstraintChildStatementCount();
    }

    public DataStatement getChildStatement(int n) {
        if (n < this.getConstraintChildStatementCount()) {
            return this.getConstraintChildStatement(n);
        }
        return super.getChildStatement(n - this.getConstraintChildStatementCount());
    }
}

