/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DataSourceFile
extends DataSource {
    protected RandomAccessFile file;

    public DataSourceFile() {
        this.file = null;
    }

    public DataSourceFile(File file) {
        this.setFile(file);
    }

    public DataSourceFile(String string) {
        this.setFile(string, true);
    }

    public void setFile(File file) {
        if (!file.exists()) {
            System.err.println("[DataSourceFile:setFile]  Error: theFile does not exist.  (theFile = \"" + file + "\").");
            this.file = null;
            return;
        }
        if (file.isDirectory()) {
            System.err.println("[DataSourceFile:setFile]  Error: theFile is a directory.  (theFile = \"" + file + "\").");
            this.file = null;
            return;
        }
        this.setFile(file.getAbsolutePath(), false);
        this.setFilenameWithoutPathDefault(file.getName());
    }

    public void setFile(String string, boolean bl) {
        super.reset();
        try {
            this.file = new RandomAccessFile(string, "r");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("[DataSourceFile:setFile]  Error: Unable to open file \"" + string + "\".  IllegalArgumentException = " + illegalArgumentException);
            this.file = null;
        }
        catch (IOException iOException) {
            System.err.println("[DataSourceFile:setFile]  Error: Unable to open file \"" + string + "\". IOException  = " + iOException);
            this.file = null;
        }
        catch (SecurityException securityException) {
            System.err.println("[DataSourceFile:setFile]  Error: Unable to open file \"" + string + "\".  SecurityException = " + securityException);
            this.file = null;
        }
        if (bl) {
            this.setFilenameWithoutPathDefault(new File(string).getName());
        }
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    public boolean hasFile() {
        return this.getFile() != null;
    }

    public char read(int n) throws IOException {
        if (!this.hasFile()) {
            throw new IOException("[DataSourceFile] File not initialized.");
        }
        this.getFile().seek(n);
        int n2 = this.getFile().read();
        if (n2 != -1) {
            return (char)n2;
        }
        throw new IOException("END-OF-FILE REACHED");
    }

    public String readSubString(int n, int n2) {
        if (!this.hasFile()) {
            System.err.println("[DataSourceFile:readSubString]  Warning:  File was never initialized.");
            return "";
        }
        if (n < 0) {
            System.err.println("[DataSourceFile:readSubString]  Warning:  theStartPosition(" + n + ") < 0");
            n = 0;
        }
        if (n2 < 0) {
            System.err.println("[DataSourceFile:readSubString]  Warning:  theEndPosition(" + n2 + ") < 0");
            n2 = 0;
        }
        if (n >= n2) {
            System.err.println("[DataSourceFile:readSubString]  Warning:  theStartPosition(" + n + ") >= theEndPosition(" + n2 + ")");
            return "";
        }
        byte[] byArray = new byte[n2 - n];
        try {
            this.getFile().seek(n);
            this.getFile().read(byArray, 0, n2 - n);
            return new String(byArray);
        }
        catch (IOException iOException) {
            System.err.println("[DataSourceFile:readSubString]  Error:  Unable to read data.  Failing...");
            return "";
        }
    }
}

