/*
 * Decompiled with CFR 0.152.
 */
public class DataJumpStatement
extends DataStatement {
    public static final String FIRST_TOKEN_INDEX = "First";
    public static final String SEMICOLON = ";";
    public static final int BREAK_TYPE = 0;
    public static final int CONTINUE_TYPE = 1;
    public static final int RETURN_TYPE = 2;
    public static final int SUCCESS_TYPE = 3;
    public static final int FAIL_TYPE = 4;
    public static final int BYPASS_TYPE = 5;
    public static final int POSTPONE_TYPE = 6;
    public static final String[] JUMP_TYPES = new String[]{"break", "continue", "return", "SUCCESS", "FAIL", "BYPASS", "POSTPONE"};
    protected int type = 2;
    protected DataExpression dataExpression = null;
    protected DataSpawnTask exceptionTask = null;

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (n == 0 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 6) {
            this.type = n;
        } else {
            System.err.println("[DataJumpStatement:setType]  Error:  Illegal type: " + n + "  Aborting set...");
        }
    }

    public DataExpression getDataExpression() {
        return this.dataExpression;
    }

    public void setDataExpression(DataExpression dataExpression) {
        if (this.dataExpression != null) {
            this.dataExpression.setParent(null);
        }
        this.dataExpression = dataExpression;
        if (this.dataExpression != null) {
            this.dataExpression.setParent(this);
        }
    }

    public DataSpawnTask getExceptionTask() {
        return this.exceptionTask;
    }

    public boolean setExceptionTask(DataSpawnTask dataSpawnTask) {
        if (dataSpawnTask != null && dataSpawnTask.getTaskName() != null && dataSpawnTask.getTaskName().length() > 0 && dataSpawnTask.getConstraintCount() == 0 || dataSpawnTask == null) {
            this.exceptionTask = dataSpawnTask;
            return true;
        }
        System.err.println("[DataJumpStatement:setExceptionTask]  Error: Bad object for theExceptionTask:  " + dataSpawnTask.toString());
        return false;
    }

    public boolean hasSubcomponentFraction(String string) {
        return super.hasSubcomponentFraction(string) || this.getDataExpression() != null && this.getDataExpression().hasSubcomponentFraction(string);
    }

    public void runOnSubcomponentFraction(String string, RunOnSubcomponentInterface runOnSubcomponentInterface, Object object) {
        super.runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        if (this.getDataExpression() != null) {
            this.getDataExpression().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
    }

    public void validateInternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) {
        DataComponent dataComponent;
        DataTaskDefinition dataTaskDefinition = this.getParentTaskDefinition();
        super.validateInternalCode(n, dataValidateCodeReturnValue);
        if (this.getType() == 0) {
            dataComponent = this.getParent();
            while (dataComponent != null && !(dataComponent instanceof DataIterationStatement) && !(dataComponent instanceof DataSwitchStatement)) {
                dataComponent = dataComponent.getParent();
            }
            if (dataComponent == null) {
                dataValidateCodeReturnValue.addWarning(this).write("Break statement outside of any enclosing iteration or switch statement.\n");
            }
        }
        if (this.getType() == 1) {
            dataComponent = this.getParent();
            while (dataComponent != null && !(dataComponent instanceof DataIterationStatement)) {
                dataComponent = dataComponent.getParent();
            }
            if (dataComponent == null) {
                dataValidateCodeReturnValue.addWarning(this).write("Continue statement outside of any enclosing iteration statement.\n");
            }
        }
        if (this.getType() == 4 && this.getExceptionTask() != null && (this.getExceptionTask().getTaskName() == null || this.getExceptionTask().getTaskName().length() <= 0)) {
            dataValidateCodeReturnValue.addError(this).write("Exception specified in FAIL statement has no name.\n");
        }
        if (dataTaskDefinition == null) {
            dataValidateCodeReturnValue.addWarning(this).write("Internal Error -- Unable to locate parent Task in ").write("DataJumpStatement.validateInternalCode().\n");
        } else {
            if (this.getType() == 4 && this.getExceptionTask() == null && dataTaskDefinition.getTaskType() != 5 && (dataTaskDefinition.getTaskType() != 6 || dataTaskDefinition.getResumeMasterTask() == null || dataTaskDefinition.getResumeMasterTask().getTaskType() != 5)) {
                dataValidateCodeReturnValue.addWarning(this).write("FAIL statement lacks an Exception.\n");
            }
            if (this.getType() == 5 && dataTaskDefinition.getTaskType() != 5) {
                dataValidateCodeReturnValue.addError(this).write("BYPASS statement encountered outside of an ").write("Exception-Handler Task.\n");
            }
        }
    }

    public boolean isValid(int n) {
        DataTaskDefinition dataTaskDefinition = this.getParentTaskDefinition();
        if (this.getType() == 4 && this.getExceptionTask() != null && (this.getExceptionTask().getTaskName() == null || this.getExceptionTask().getTaskName().length() <= 0)) {
            return false;
        }
        if (this.getType() == 4 && this.getExceptionTask() == null && dataTaskDefinition != null && dataTaskDefinition.getTaskType() != 5) {
            return false;
        }
        return super.isValid(n);
    }

    public void generateReturn(DataDestination dataDestination, int n, boolean bl, boolean bl2) {
        if (bl) {
            dataDestination.setUsingTdlFileName(false);
            dataDestination.write("\n");
            dataDestination.write("_TDL_DO_TCM_SUCCESS");
            dataDestination.write(" ( ");
            dataDestination.write("_TDL_ENCLOSING_TASK");
            dataDestination.write(" );");
        }
        if (bl2) {
            dataDestination.setUsingTdlFileName(true);
            dataDestination.makeNextLineNumber(this.getLineNumber());
        } else {
            dataDestination.setUsingTdlFileName(false);
        }
        dataDestination.write("\n");
        dataDestination.write("return");
        if (this.getDataExpression() != null) {
            this.getDataExpression().generate(dataDestination, n);
        }
    }

    public void generate(DataDestination dataDestination, int n) {
        DataTaskDefinition dataTaskDefinition = this.getParentTaskDefinition();
        this.warnIfInvalidObjectSubset(n, "generate");
        this.initializeGenerateSubcomponentIndex();
        this.generateLabels(dataDestination, n, FIRST_TOKEN_INDEX);
        this.generateSubcomponents(FIRST_TOKEN_INDEX, dataDestination, n, false);
        if (this.getType() == 0 || this.getType() == 1) {
            dataDestination.write(JUMP_TYPES[this.getType()]);
        } else if (this.getType() == 2) {
            this.generateReturn(dataDestination, n, this.isCxxSubset(n), true);
        } else if (this.getType() == 3 || this.getType() == 5 || this.getType() == 6 || this.getType() == 4 && this.getExceptionTask() == null && dataTaskDefinition != null && this.isCxxSubset(n) && (dataTaskDefinition.getTaskType() == 5 || dataTaskDefinition.getTaskType() == 6 && dataTaskDefinition.getResumeMasterTask() != null && dataTaskDefinition.getResumeMasterTask().getTaskType() == 5)) {
            if (this.isCxxSubset(n)) {
                dataDestination.write("// ");
            }
            dataDestination.write(JUMP_TYPES[this.getType()]);
            if (this.isCxxSubset(n)) {
                dataDestination.write(" ;\n");
                if (this.getType() == 5 || this.getType() == 4) {
                    dataDestination.write("_TDL_DO_TCM_BYPASS");
                    dataDestination.write(" ( ");
                    dataDestination.write("_TDL_ENCLOSING_TASK");
                    dataDestination.write(" );\n");
                }
                this.generateReturn(dataDestination, n, this.getType() == 3, false);
            }
        } else if (this.getType() == 4) {
            int n2;
            if (this.isCxxSubset(n)) {
                dataDestination.setNewlineText("// ");
                dataDestination.write("// ");
            }
            dataDestination.write(JUMP_TYPES[this.getType()]);
            if (this.getExceptionTask() != null) {
                n2 = dataDestination.indentToCurrentColumn();
                if (n2 >= dataDestination.getNewlineText().length()) {
                    dataDestination.removeIndent(dataDestination.getNewlineText().length());
                    n2 -= dataDestination.getNewlineText().length();
                }
                this.getExceptionTask().generate(dataDestination, 3);
                dataDestination.removeIndent(n2);
            }
            if (this.isCxxSubset(n)) {
                dataDestination.write(" ;");
                dataDestination.clearNewlineText();
                dataDestination.setUsingTdlFileName(false);
                dataDestination.write("\n");
                dataDestination.write("_TDL_DO_TCM_FAIL");
                dataDestination.write(" ( ");
                n2 = dataDestination.indentToCurrentColumn();
                dataDestination.write("_TDL_ENCLOSING_TASK");
                dataDestination.write(",\n");
                if (this.getExceptionTask() != null) {
                    dataDestination.write("_TDL_Exception_");
                    dataDestination.write(this.getExceptionTask().getTaskName());
                } else {
                    dataDestination.write("_TDL_BaseException");
                }
                dataDestination.write("::");
                dataDestination.write("exceptionMatches");
                dataDestination.write(",\n");
                dataDestination.write("_TDL_CreateException_");
                dataDestination.addIndent("_TDL_CreateException_".length());
                n2 += "_TDL_CreateException_".length();
                dataDestination.setStripLeadingWhitespace();
                if (this.getExceptionTask() != null) {
                    int n3 = this.getExceptionTask().getLeadingWhitespaceIndent("taskNameIndex");
                    if (dataDestination.getIndent() > n3) {
                        dataDestination.removeIndent(n3);
                        n2 -= n3;
                    }
                    this.getExceptionTask().generateTask(dataDestination, 0, false, false, true, false, this.isCxxSubset(n));
                } else {
                    dataDestination.write("_TDL_BaseException");
                    dataDestination.write("()");
                }
                dataDestination.removeIndent(n2);
                dataDestination.write(" );\n");
                this.generateReturn(dataDestination, n, false, false);
            }
        } else {
            System.err.println("[DataJumpStatement:generate]  Error:  Illegal type: " + this.getType());
        }
        this.generateSubcomponents(SEMICOLON, dataDestination, n, false);
        dataDestination.write(SEMICOLON);
        this.generateAllRemainingSubcomponents(dataDestination, n, false);
    }
}

