/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.Enumeration;

public class DataFile
extends DataComponent
implements DataValidateCode {
    public static final String STANDARD_CXX_HEADER_TAIL = ".H";
    public static final String STANDARD_CXX_CODE_TAIL = ".C";
    public static final String STANDARD_HTML_TAIL = ".html";
    public static final String TDL_FILENAME_SUFFIX = ".tdl";
    public static final String USING_INDEX = "U";
    public static final String DEFAULT_INCLUDES = "\n#include <tdl.H>\n";
    public static final int SHOW_USING = 1100;
    public static final int HIDE_USING = 1101;
    public static final int TRANSLATE_USING = 1102;
    protected static boolean overrideInMessagesFilenamesWithLine = false;
    protected static Registry fileRegistry = new Registry(false);
    protected boolean hasLoadedUsingFiles = false;
    protected DataVector usingFiles = new DataVector();
    protected String filename;
    protected DataSource nullDataSource;

    public static boolean getOverrideInMessagesFilenamesWithLine() {
        return overrideInMessagesFilenamesWithLine;
    }

    public static void setOverrideInMessagesFilenamesWithLine(boolean bl) {
        overrideInMessagesFilenamesWithLine = bl;
    }

    protected static Registry getFileRegistry() {
        return fileRegistry;
    }

    public static boolean unregisterFile(DataFile dataFile) {
        if (DataFile.getFileRegistry().getIsObjectRegistered(dataFile) && !DataFile.getFileRegistry().unregister(dataFile)) {
            System.err.println("[DataFile:unregisterFile]  Warning:  File was unregistered...  (\"" + dataFile.getFilename() + "\")");
            return false;
        }
        return true;
    }

    public static boolean registerFile(DataFile dataFile) {
        if (DataComponent.isEmptyString(dataFile.getFilename())) {
            return true;
        }
        if (!DataFile.getFileRegistry().register(dataFile.getFilename(), dataFile)) {
            System.err.println("[DataFile:registerFile] Warning:  File registration failed..  (\"" + dataFile.getFilename() + "\")");
            return false;
        }
        return true;
    }

    public static DataFile getFileForPath(String string) {
        return (DataFile)DataFile.getFileRegistry().getFirstObjectForName(string);
    }

    public static String getNameForFile(DataFile dataFile) {
        return DataFile.getFileRegistry().getNameForObject(dataFile);
    }

    public static boolean getIsFileRegistered(DataFile dataFile) {
        return DataFile.getFileRegistry().getIsObjectRegistered(dataFile);
    }

    public static boolean getIsFilenameRegistered(String string) {
        return DataFile.getFileRegistry().getIsNameRegistered(string);
    }

    public static Enumeration getRegisteredFiles() {
        return DataFile.getFileRegistry().getObjects();
    }

    public static DataFile loadDataFile(File file) throws DetailedParseException {
        if (DataFile.getIsFilenameRegistered(file.getAbsolutePath())) {
            System.err.println("[DataFile:loadDataFile]  Warning:  Multiple load of file \"" + file.getAbsolutePath() + "\"  detected and aborted.  Reusing previous DataFile object.");
            return DataFile.getFileForPath(file.getAbsolutePath());
        }
        TDLParser.reinitParser(file);
        return DataFile.privateLoadDataFile(file.getAbsolutePath(), file.getName());
    }

    public static DataFile loadDataFile(String string) throws DetailedParseException {
        TDLParser.reinitParser(string);
        return DataFile.privateLoadDataFile("", "");
    }

    protected static DataFile privateLoadDataFile(String string, String string2) throws DetailedParseException {
        try {
            DataFile dataFile = TDLParser.parseFile(null);
            dataFile.setFilename(string);
            dataFile.setNullDataSource(new DataSourceNull(string2));
            dataFile.registerFile("DataFile:loadDataFile");
            dataFile.registerTasks();
            dataFile.establishFilenameBasedUniqueIdentifieresForTasks();
            dataFile.mapResumeTasks();
            return dataFile;
        }
        catch (Throwable throwable) {
            DataComponent.didParseOfSubpartFail(throwable);
            System.err.println("[DataFile:loadDataFile]  Warning:  Impossible error has occurred.");
            return null;
        }
    }

    public static String makeTDLFilename(String string) {
        if (string.endsWith(TDL_FILENAME_SUFFIX)) {
            return string;
        }
        return string + TDL_FILENAME_SUFFIX;
    }

    public static String translateTDLFilenameToCxx(String string, String string2) {
        if (string.endsWith(TDL_FILENAME_SUFFIX)) {
            return string.substring(0, string.length() - TDL_FILENAME_SUFFIX.length()) + string2;
        }
        return string;
    }

    public DataFile() {
        this("");
    }

    public DataFile(String string) {
        this.setFilename(string);
        this.setNullDataSource(null);
    }

    public boolean getIsEmpty() {
        return this.getSubcomponentsCount() <= 0;
    }

    public DataVector getUsingFiles() {
        return this.usingFiles;
    }

    public String getUsingFile(int n) {
        if (n >= 0 && n < this.getUsingFiles().count()) {
            return (String)this.getUsingFiles().elementAt(n);
        }
        System.err.println("[DataFile:getUsingFile]  Warning:  Illegal index (" + n + ").");
        return null;
    }

    public void addUsingFile(String string) {
        if (string.charAt(0) != '\"' && string.charAt(0) != '<') {
            System.err.println("[DataFile:addUsingFile]  Warning:  Invalid first character of string (\"" + string.charAt(0) + "\").");
        }
        if (string.charAt(string.length() - 1) != '\"' && string.charAt(string.length() - 1) != '>') {
            System.err.println("[DataFile:addUsingFile]  Warning:  Invalid last character of string (\"" + string.charAt(string.length() - 1) + "\").");
        }
        this.getUsingFiles().addElement(string);
    }

    public void addUsingFileAndStripUsing(String string) {
        int n = 0;
        if (string.charAt(n) == '#') {
            ++n;
        }
        while (string.charAt(n) == ' ' || string.charAt(n) == '\t') {
            ++n;
        }
        if (string.charAt(n) == 'u' || string.charAt(n) == 'U') {
            ++n;
        }
        if (string.charAt(n) == 's' || string.charAt(n) == 'S') {
            ++n;
        }
        if (string.charAt(n) == 'i' || string.charAt(n) == 'I') {
            ++n;
        }
        if (string.charAt(n) == 'n' || string.charAt(n) == 'N') {
            ++n;
        }
        if (string.charAt(n) == 'g' || string.charAt(n) == 'G') {
            ++n;
        }
        while (string.charAt(n) == ' ' || string.charAt(n) == '\t') {
            ++n;
        }
        this.addUsingFile(string.substring(n));
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public DataSource getNullDataSource() {
        return this.nullDataSource;
    }

    public void setNullDataSource(DataSource dataSource) {
        this.nullDataSource = dataSource;
    }

    public String getMessageFilenameLead() {
        if (this.getNullDataSource() == null) {
            return "Line:";
        }
        return this.getNullDataSource().getFilenameWithoutPathPlusColon();
    }

    public boolean registerFile(String string) {
        if (!DataFile.registerFile(this)) {
            System.err.println("[DataFile:registerFile] --  [\"" + string + "\"] --  " + "Error:  New Registration of file has failed. (\"" + this.getFilename() + "\").");
            return false;
        }
        return true;
    }

    public boolean unregisterFile(String string) {
        if (!DataFile.unregisterFile(this)) {
            System.err.println("[DataFile:unregisterFile] --  [\"" + string + "\"] --  " + "Warning:  unregistration of file has failed.  (\"" + this.getFilename() + "\").");
            return false;
        }
        return true;
    }

    public boolean getIsFileRegistered() {
        return DataFile.getIsFileRegistered(this);
    }

    protected boolean registerTasks() throws DetailedParseException {
        boolean bl = true;
        int n = 0;
        while (n < this.getSubcomponentsCount()) {
            if (this.isSubcomponentADataComponent(n) && this.getDataComponentSubcomponent(n) instanceof DataTaskDefinition && ((DataTaskDefinition)this.getDataComponentSubcomponent(n)).getTaskType() != 6 && !((DataTaskDefinition)this.getDataComponentSubcomponent(n)).registerTask("DataFile:registerTasks", true)) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    protected void establishFilenameBasedUniqueIdentifieresForTasks() {
        DataHashtable dataHashtable = new DataHashtable();
        String string = "_" + this.getFilenameBasedUniqueIdentifierString(false, false, false) + "_";
        int n = 0;
        while (n < this.getSubcomponentsCount()) {
            if (this.isSubcomponentADataComponent(n) && this.getDataComponentSubcomponent(n) instanceof DataTaskDefinition && ((DataTaskDefinition)this.getDataComponentSubcomponent(n)).getTaskType() != 6) {
                DataTaskDefinition dataTaskDefinition = (DataTaskDefinition)this.getDataComponentSubcomponent(n);
                String string2 = dataTaskDefinition.getTaskName();
                int n2 = 0;
                Object v = dataHashtable.get(dataTaskDefinition.getTaskName());
                while (v != null) {
                    string2 = v;
                    ++n2;
                    v = dataHashtable.get(v);
                }
                dataHashtable.put(string2, dataTaskDefinition);
                dataTaskDefinition.setUniqueIdString(string + n2);
            }
            ++n;
        }
    }

    protected void mapResumeTasks() throws DetailedParseException {
        DataHashtable dataHashtable = new DataHashtable();
        int n = 0;
        while (n < this.getSubcomponentsCount()) {
            if (this.isSubcomponentADataComponent(n) && this.getDataComponentSubcomponent(n) instanceof DataTaskDefinition) {
                ((DataTaskDefinition)this.getDataComponentSubcomponent(n)).clearResumeTasksVector();
                ((DataTaskDefinition)this.getDataComponentSubcomponent(n)).setResumeMasterTask(null);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.getSubcomponentsCount()) {
            if (this.isSubcomponentADataComponent(n2) && this.getDataComponentSubcomponent(n2) instanceof DataTaskDefinition) {
                DataTaskDefinition dataTaskDefinition = (DataTaskDefinition)this.getDataComponentSubcomponent(n2);
                if (DataComponent.isEmptyString(dataTaskDefinition.getTaskName())) {
                    System.err.println("[DataFile:mapResumeTasks]  Warning: Null task-name encountered.  Skipping...");
                } else if (dataTaskDefinition.getTaskType() != 6) {
                    dataHashtable.put(dataTaskDefinition.getTaskName(), dataTaskDefinition);
                } else {
                    DataTaskDefinition dataTaskDefinition2 = dataTaskDefinition;
                    DataTaskDefinition dataTaskDefinition3 = (DataTaskDefinition)dataHashtable.get(dataTaskDefinition2.getTaskName());
                    if (dataTaskDefinition3 == null) {
                        dataTaskDefinition3 = DataTaskDefinition.getFirstTaskForName(dataTaskDefinition2.getTaskName());
                    }
                    if (dataTaskDefinition3 == null && !dataTaskDefinition2.getIsExtern()) {
                        throw new DetailedParseException(dataTaskDefinition2.getMessageFilenameLead() + dataTaskDefinition2.getLineNumberString() + ":  Error:  Resume Task named \"" + dataTaskDefinition2.getTaskName() + "\" has no corresponding counterpart.");
                    }
                    if (dataTaskDefinition3 != null) {
                        if (dataTaskDefinition3.getTaskType() == 4) {
                            throw new DetailedParseException(dataTaskDefinition2.getMessageFilenameLead() + dataTaskDefinition2.getLineNumberString() + ":  Error:  Resume Task named \"" + dataTaskDefinition2.getTaskName() + "\" may not resume an EXCEPTION Task.");
                        }
                        dataTaskDefinition3.addResumeTask(dataTaskDefinition2);
                        dataTaskDefinition2.setResumeMasterTask(dataTaskDefinition3);
                    }
                }
            }
            ++n2;
        }
    }

    public void loadAttachedFiles(DataVector dataVector, DataVector dataVector2, boolean bl) throws CompilationException {
        DataVector dataVector3 = null;
        if (this.hasLoadedUsingFiles) {
            if (bl) {
                System.err.println("#using files are already loaded for file \"" + this.getFilename() + "\".");
            }
            return;
        }
        if (bl) {
            System.err.println("Loading #using files for \"" + this.getFilename() + "\".   ( Memory = " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory() + " ).");
        }
        this.hasLoadedUsingFiles = true;
        int n = 0;
        while (n < this.getUsingFiles().count()) {
            String string = this.getUsingFile(n).substring(1, this.getUsingFile(n).length() - 1);
            switch (this.getUsingFile(n).charAt(0)) {
                case '\"': {
                    dataVector3 = dataVector;
                    break;
                }
                case '<': {
                    dataVector3 = dataVector2;
                    break;
                }
                default: {
                    dataVector3 = null;
                    System.err.println("[DataFile:loadAttachedFiles]  Warning:  Unable to load file for invalid statement:  #using " + this.getUsingFile(n));
                }
            }
            int n2 = 0;
            while (dataVector3 != null && n2 < dataVector3.count()) {
                File file = (File)dataVector3.elementAt(n2);
                if (!file.isDirectory()) {
                    System.err.println("[DataFile:loadAttachedFiles]  Warning:  Bad search directory:  \"" + file.getAbsolutePath() + "\".");
                } else {
                    File file2 = new File(file, string);
                    if (file2.exists()) {
                        if (!DataFile.getIsFilenameRegistered(file2.getAbsolutePath())) {
                            try {
                                if (bl) {
                                    System.err.println("Loading File \"" + file2.getAbsolutePath() + "\".");
                                }
                                DataFile.loadDataFile(file2);
                            }
                            catch (DetailedParseException detailedParseException) {
                                throw new CompilationException("Error:  Encountered Parse Exception in file \"" + file2.getAbsolutePath() + "\", which was #using'ed from file \"" + this.getFilename() + "\":\n" + detailedParseException.toString());
                            }
                        } else if (bl) {
                            System.err.println("File \"" + file2.getAbsolutePath() + "\" was already loaded.");
                        }
                        DataFile dataFile = DataFile.getFileForPath(file2.getAbsolutePath());
                        if (dataFile == null) {
                            System.err.println("[DataFile:loadAttachedFiles]  Warning:  Programmatical Error.  Unable to load #using files for \"" + file2.getAbsolutePath() + "\".");
                            break;
                        }
                        dataFile.loadAttachedFiles(dataVector, dataVector2, bl);
                        break;
                    }
                }
                ++n2;
            }
            if (dataVector3 == null || n2 >= dataVector3.count()) {
                throw new CompilationException("Error:  Unable to locate #using file \"" + string + "\".  (Which was #using'ed from file \"" + this.getFilename() + "\")");
            }
            ++n;
        }
        if (bl) {
            System.err.println("..Finished Loading #using files for \"" + this.getFilename() + "\".   ( Memory = " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory() + " ).");
        }
    }

    public void validateExternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        int n2 = 0;
        while (n2 < this.getSubcomponentsCount()) {
            if (this.isSubcomponentADataComponent(n2) && this.getDataComponentSubcomponent(n2) instanceof DataValidateCode) {
                ((DataValidateCode)((Object)this.getDataComponentSubcomponent(n2))).validateExternalCode(n, dataValidateCodeReturnValue);
            }
            ++n2;
        }
    }

    public void validateInternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        throw new CompilationException("Internal Error:  DataFile object may not exist inside a Task.");
    }

    public String getWarnString(int n) {
        return super.getWarnString(n) + " or DataComponent.HTML_DOCUMENTATION (" + 2000 + ")";
    }

    public boolean isValidObjectSubset(int n) {
        return n == 2000 || super.isValidObjectSubset(n);
    }

    public String getFilenameBasedUniqueIdentifierString(boolean bl, boolean bl2, boolean bl3) {
        String string = this.getMessageFilenameLead();
        String string2 = bl ? "_TDL_" : "";
        if (string.equals("Line:") || string.equals("stdin:")) {
            if (bl2) {
                return this.getUniqueIdentifierString(string2 + "STDIN:");
            }
            return this.getUniqueIdentifierString(new StringBuffer(string2 + "STDIN"));
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        String string3 = string.substring(0, string.length() - 1);
        if (bl3) {
            string3 = DataFile.translateTDLFilenameToCxx(string3, STANDARD_CXX_HEADER_TAIL);
        }
        stringBuffer.append(string3);
        return this.getUniqueIdentifierString(stringBuffer);
    }

    public String generateBeginningOfFile(DataDestination dataDestination, int n) {
        String string = null;
        if (this.isCxxHeaderSubset(n)) {
            string = this.getFilenameBasedUniqueIdentifierString(true, true, true);
            dataDestination.write("\n#ifndef ");
            dataDestination.write(string);
            dataDestination.write("\n#define ");
            dataDestination.write(string);
            dataDestination.write("\n");
            dataDestination.write(DEFAULT_INCLUDES);
            dataDestination.write("\n");
        }
        return string;
    }

    public void generateEndingOfFile(DataDestination dataDestination, String string) {
        if (string != null) {
            dataDestination.write("\n\n#endif /*");
            dataDestination.write(string);
            dataDestination.write("*/\n\n");
        }
    }

    public void generate(DataDestination dataDestination, int n) {
        this.generate(dataDestination, n, 1100, true, true);
    }

    public void generate(DataDestination dataDestination, int n, int n2, boolean bl, boolean bl2) {
        this.warnIfInvalidObjectSubset(n, "generate");
        if (n == 2000) {
            this.generateHTML(dataDestination, true);
            return;
        }
        String string = this.generateBeginningOfFile(dataDestination, n);
        int n3 = 0;
        int n4 = 0;
        while (n4 <= this.getUsingFiles().count()) {
            int n5 = n4 < this.getUsingFiles().count() ? this.getIndex(USING_INDEX + n4) : this.getSubcomponentsCount();
            while (n3 < n5) {
                if (this.isSubcomponentAString(n3)) {
                    if (bl2) {
                        dataDestination.write(this.getStringSubcomponent(n3));
                    }
                } else if (this.isSubcomponentADataComponent(n3)) {
                    DataComponent dataComponent = this.getDataComponentSubcomponent(n3);
                    if (dataComponent instanceof DataTaskDefinition && (bl || !((DataTaskDefinition)dataComponent).getIsExtern()) || !(dataComponent instanceof DataTaskDefinition) && bl2) {
                        dataComponent.generate(dataDestination, n);
                    } else if (dataComponent instanceof DataExternH || dataComponent instanceof DataDistributedTypedef || dataComponent instanceof DataDistributedStruct || dataComponent instanceof DataDistributedEnum) {
                        dataComponent.generate(dataDestination, n);
                    }
                } else {
                    System.err.println("[DataFile:generate]  Warning:  Unrecognized subcomponent \"" + this.getSubcomponent(n3).getClass().getName() + "\".  Skipping...");
                }
                ++n3;
            }
            if (n4 < this.getUsingFiles().count()) {
                switch (n2) {
                    case 1100: {
                        if (dataDestination.getColumn() != 0) {
                            dataDestination.write("\n");
                        }
                        dataDestination.write("# using ");
                        dataDestination.write(this.getUsingFile(n4));
                        if (bl2) break;
                        dataDestination.write("\n");
                        break;
                    }
                    case 1101: {
                        break;
                    }
                    case 1102: {
                        if (dataDestination.getColumn() != 0) {
                            dataDestination.write("\n");
                        }
                        dataDestination.write("#include ");
                        dataDestination.write(this.getUsingFile(n4).substring(0, 1));
                        dataDestination.write(DataFile.translateTDLFilenameToCxx(this.getUsingFile(n4).substring(1, this.getUsingFile(n4).length() - 1), STANDARD_CXX_HEADER_TAIL));
                        dataDestination.write(this.getUsingFile(n4).substring(this.getUsingFile(n4).length() - 1, this.getUsingFile(n4).length()));
                        if (bl2) break;
                        dataDestination.write("\n");
                    }
                }
            }
            ++n4;
        }
        this.generateEndingOfFile(dataDestination, string);
    }

    public void generateHTMLHeader(DataDestination dataDestination) {
        this.generateHTMLHeader(dataDestination, null);
    }

    public void generateHTMLHeader(DataDestination dataDestination, String string) {
        dataDestination.write("<HTML>\n<HEAD>\n<TITLE>");
        if (string != null) {
            dataDestination.write(string);
        } else if (this.getFilename() != null) {
            dataDestination.write("File: ");
            dataDestination.write(this.getFilename());
        } else {
            dataDestination.write("Untitled");
        }
        dataDestination.write("</TITLE>\n</HEAD>\n<BODY>\n");
    }

    public void generateHTMLTrailer(DataDestination dataDestination) {
        dataDestination.write("\n</BODY>\n</HTML>\n");
    }

    public void generateHTML(DataDestination dataDestination, boolean bl) {
        if (bl) {
            this.generateHTMLHeader(dataDestination);
        }
        if (!bl) {
            dataDestination.write("<BR><BR><HR>\n");
        }
        dataDestination.write("<H1 ALIGN=CENTER>");
        dataDestination.write("File: ");
        dataDestination.write(this.getFilename());
        dataDestination.write("</H1><HR><BR>\n");
        int n = 0;
        while (n < this.getSubcomponentsCount()) {
            if (this.isSubcomponentADataComponent(n) && this.getDataComponentSubcomponent(n) instanceof DataTaskDefinition) {
                ((DataTaskDefinition)this.getDataComponentSubcomponent(n)).generate(dataDestination, 2000);
            }
            ++n;
        }
        if (bl) {
            this.generateHTMLTrailer(dataDestination);
        }
    }
}

