/*
 * Decompiled with CFR 0.152.
 */
public class DataDestinationAbstractBaseClass
implements DataDestination {
    public static final int NO_MAKE_NEXT_LINE_NUMBER = -101;
    public static final int RESET_TO_CURRENT_ROW = -1001;
    protected boolean hasClosed;
    protected boolean needsToIndent;
    protected boolean secondaryIndentEnabled;
    protected boolean isStrippingLeadingWhitespace;
    protected boolean isStrippingLeadingSpaces;
    protected boolean isPersistentlyStrippingLeadingSpaces;
    protected int indent;
    protected int type;
    protected int length;
    protected int row;
    protected int column;
    protected int secondaryIndent;
    protected String newlineText;
    protected boolean enableLineMacros;
    protected boolean usingTdlFileName;
    protected String tdlFileName;
    protected String cxxFileName;
    protected int rowOffset;
    protected int makeNextLineNumber;
    protected boolean isNestingComments;
    protected boolean isConcatenatingStrings;
    protected boolean hasStartingQuote;
    protected boolean hasEndingQuote;

    public DataDestinationAbstractBaseClass() {
        this.reset();
    }

    public boolean getNeedsToIndent() {
        return this.needsToIndent;
    }

    public void setNeedsToIndent(boolean bl) {
        this.needsToIndent = bl;
    }

    public void reset() {
        this.hasClosed = false;
        this.needsToIndent = false;
        this.isStrippingLeadingWhitespace = false;
        this.isStrippingLeadingSpaces = false;
        this.isPersistentlyStrippingLeadingSpaces = false;
        this.secondaryIndentEnabled = false;
        this.indent = 0;
        this.type = 0;
        this.length = 0;
        this.row = 0;
        this.column = 0;
        this.secondaryIndent = 0;
        this.newlineText = "";
        this.enableLineMacros = false;
        this.usingTdlFileName = true;
        this.tdlFileName = null;
        this.cxxFileName = null;
        this.rowOffset = 0;
        this.clearMakeNextLineNumber();
        this.isNestingComments = false;
        this.isConcatenatingStrings = false;
        this.hasStartingQuote = false;
        this.hasEndingQuote = false;
    }

    public boolean getHasClosed() {
        return this.hasClosed;
    }

    public void close() {
        this.hasClosed = true;
    }

    public int getType() {
        return this.type;
    }

    public boolean setType(int n) {
        if (n >= 0 && n <= 5) {
            this.type = n;
            return true;
        }
        return false;
    }

    public int getIndent() {
        return this.indent;
    }

    public void addIndent(int n) {
        this.indent += n;
        if (this.indent < 0) {
            this.indent = 0;
        }
    }

    public void removeIndent(int n) {
        this.addIndent(-n);
    }

    public int indentToCurrentColumn() {
        int n = this.getColumn() - this.getIndent();
        if (n < 0) {
            n = 0;
        }
        this.addIndent(n);
        return n;
    }

    public int getSecondaryIndent() {
        return this.secondaryIndent;
    }

    public void addSecondaryIndent(int n) {
        this.secondaryIndent += n;
        if (this.secondaryIndent < 0) {
            this.secondaryIndent = 0;
        }
    }

    public void removeSecondaryIndent(int n) {
        this.addSecondaryIndent(-n);
    }

    public boolean getIsSecondaryIndentEnabled() {
        return this.secondaryIndentEnabled;
    }

    public void enableSecondaryIndent() {
        if (!this.getIsSecondaryIndentEnabled()) {
            this.secondaryIndentEnabled = true;
            this.addIndent(this.getSecondaryIndent());
        } else {
            System.err.println("[DataDestinationAbstractBaseClass:enableSecondaryIndent]  Warning:  SecondaryIndent Already ENABLED.");
        }
    }

    public void disableSecondaryIndent() {
        if (this.getIsSecondaryIndentEnabled()) {
            this.secondaryIndentEnabled = false;
            this.removeIndent(this.getSecondaryIndent());
        } else {
            System.err.println("[DataDestinationAbstractBaseClass:disableSecondaryIndent]  Warning:  SecondaryIndent Already DISABLED.");
        }
    }

    public void setStripLeadingWhitespace() {
        this.setStripLeadingWhitespace(true);
    }

    public void setStripLeadingWhitespace(boolean bl) {
        this.isStrippingLeadingWhitespace = bl;
    }

    public boolean getIsStrippingLeadingWhitespace() {
        return this.isStrippingLeadingWhitespace;
    }

    public void setStripLeadingSpaces() {
        this.setStripLeadingSpaces(true);
    }

    public void setStripLeadingSpaces(boolean bl) {
        this.isStrippingLeadingSpaces = bl;
    }

    public boolean getIsStrippingLeadingSpaces() {
        return this.isStrippingLeadingSpaces;
    }

    public void setPersistentlyStripLeadingSpaces() {
        this.setPersistentlyStripLeadingSpaces(true);
    }

    public void setPersistentlyStripLeadingSpaces(boolean bl) {
        this.isPersistentlyStrippingLeadingSpaces = bl;
        this.setStripLeadingSpaces(bl);
    }

    public boolean getIsPersistentlyStrippingLeadingSpaces() {
        return this.isPersistentlyStrippingLeadingSpaces;
    }

    public String getNewlineText() {
        return this.newlineText;
    }

    public void setNewlineText(String string) {
        this.newlineText = string;
    }

    public void clearNewlineText() {
        this.setNewlineText("");
    }

    public int getLength() {
        return this.length;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public void spaceToColumn(int n) {
        if (this.getIsStrippingLeadingWhitespace()) {
            this.setStripLeadingWhitespace(false);
        }
        while (this.getColumn() < n) {
            this.write(" ");
        }
    }

    public void setEnableLineMacros(boolean bl) {
        this.enableLineMacros = bl;
    }

    public boolean getEnableLineMacros() {
        return this.enableLineMacros;
    }

    public void setUsingTdlFileName(boolean bl) {
        if (this.getEnableLineMacros() && this.usingTdlFileName && !bl) {
            this.makeNextLineNumber(-1001);
        }
        this.usingTdlFileName = bl;
    }

    public boolean getUsingTdlFileName() {
        return this.usingTdlFileName;
    }

    public void setTdlFileName(String string) {
        this.tdlFileName = string;
    }

    public String getTdlFileName() {
        return this.tdlFileName;
    }

    public void setCxxFileName(String string) {
        this.cxxFileName = string;
    }

    public String getCxxFileName() {
        return this.cxxFileName;
    }

    public String getCurrentFileName() {
        if (this.getUsingTdlFileName()) {
            return this.getTdlFileName();
        }
        return this.getCxxFileName();
    }

    protected void setRowOffset(int n) {
        this.rowOffset = n;
    }

    protected int getRowOffset() {
        return this.rowOffset;
    }

    public void makeNextLineNumber(int n) {
        this.makeNextLineNumber = n;
    }

    public void makeNextLineNumber(DataComponent dataComponent) {
        this.makeNextLineNumber(dataComponent.getLineNumber() - dataComponent.countLeadingSubcomponentNewlines());
    }

    public int getMakeNextLineNumber() {
        return this.makeNextLineNumber;
    }

    public void clearMakeNextLineNumber() {
        this.makeNextLineNumber(-101);
    }

    public boolean hasMakeNextLineNumber() {
        return this.getMakeNextLineNumber() != -101;
    }

    public void copyLineMacroSettingsFrom(DataDestination dataDestination) {
        this.setEnableLineMacros(false);
        this.setUsingTdlFileName(dataDestination.getUsingTdlFileName());
        this.setEnableLineMacros(dataDestination.getEnableLineMacros());
        this.setTdlFileName(dataDestination.getTdlFileName());
        this.setCxxFileName(dataDestination.getCxxFileName());
        this.row = dataDestination.getRow();
    }

    public boolean getIsNestingComments() {
        return this.isNestingComments;
    }

    public void setIsNestingComments(boolean bl) {
        this.isNestingComments = bl;
    }

    public boolean getIsConcatenatingStrings() {
        return this.isConcatenatingStrings;
    }

    public void setIsConcatenatingStrings(boolean bl) {
        this.isConcatenatingStrings = bl;
        if (this.getHasEndingQuote()) {
            this.write("\"");
        }
        this.clearHasStartingQuote();
        this.clearHasEndingQuote();
    }

    protected boolean getHasStartingQuote() {
        return this.hasStartingQuote;
    }

    protected void setHasStartingQuote() {
        this.hasStartingQuote = true;
    }

    protected void clearHasStartingQuote() {
        this.hasStartingQuote = false;
    }

    protected boolean getHasEndingQuote() {
        return this.hasEndingQuote;
    }

    protected void setHasEndingQuote() {
        this.hasEndingQuote = true;
    }

    protected void clearHasEndingQuote() {
        this.hasEndingQuote = false;
    }

    public int getAdjustedCurrentRow() {
        return this.getRow() - this.getRowOffset();
    }

    public void writeNewline() {
        if (this.getMakeNextLineNumber() == -1001) {
            this.makeNextLineNumber(this.getRow() + 1 + 1 + (this.getColumn() != 0 ? 1 : 0));
        }
        if (this.getEnableLineMacros() && this.hasMakeNextLineNumber() && this.getAdjustedCurrentRow() != this.getMakeNextLineNumber() - 1) {
            if (this.getCurrentFileName() == null) {
                System.err.println("[DataDestinationAbstractBaseClass:writeNewline]  Error:  Current Filename is unknown.");
                this.writeWithoutIndenting("\n");
            } else {
                if (this.getColumn() != 0) {
                    this.writeWithoutIndenting("\n");
                }
                this.writeWithoutIndenting("#line " + this.getMakeNextLineNumber() + " \"" + this.getCurrentFileName() + "\"\n");
                this.setRowOffset(this.getRow() - this.getMakeNextLineNumber());
            }
        } else {
            this.writeWithoutIndenting("\n");
        }
        this.clearMakeNextLineNumber();
        if (this.getIsPersistentlyStrippingLeadingSpaces()) {
            this.setStripLeadingSpaces(true);
        }
    }

    public DataDestination write(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        if (this.getIsStrippingLeadingWhitespace() || this.getIsStrippingLeadingSpaces()) {
            n = 0;
            while (n < string.length() && (this.getIsStrippingLeadingWhitespace() && (string.charAt(n) == ' ' || string.charAt(n) == '\t' || string.charAt(n) == '\n' || string.charAt(n) == '\r' || string.charAt(n) == '\f') || this.getIsStrippingLeadingSpaces() && string.charAt(n) == ' ')) {
                ++n;
            }
            if (n >= string.length()) {
                this.writeWithoutIndenting("");
                return this;
            }
            if (n > 0) {
                n2 = n;
                n3 = n;
            }
            this.setStripLeadingWhitespace(false);
            this.setStripLeadingSpaces(false);
        }
        while (n3 < string.length()) {
            if (this.getNeedsToIndent() && string.charAt(n2) != '\n') {
                n = 0;
                while (n < this.getIndent()) {
                    this.writeWithoutIndenting(" ");
                    ++n;
                }
                this.setNeedsToIndent(false);
            }
            n3 = string.indexOf("\n", n2);
            if (this.getIsNestingComments()) {
                int n4 = string.indexOf("/*", n2);
                if (n4 != -1 && (n3 == -1 || n4 < n3)) {
                    n3 = n4;
                }
                if ((n4 = string.indexOf("*/", n2)) != -1 && (n3 == -1 || n4 < n3)) {
                    n3 = n4;
                }
            }
            if (this.getIsConcatenatingStrings()) {
                int n5;
                if (this.getHasEndingQuote()) {
                    if (string.charAt(n2) == '\"') {
                        this.clearHasEndingQuote();
                        ++n2;
                    } else {
                        this.clearHasStartingQuote();
                        this.clearHasEndingQuote();
                        this.writeWithoutIndenting("\"");
                    }
                }
                if ((n5 = string.indexOf("\"", n2)) != -1 && (n3 == -1 || n5 < n3)) {
                    n3 = n5;
                }
            }
            if (n3 == -1) {
                n3 = string.length();
            }
            this.writeWithoutIndenting(string.substring(n2, n3));
            if (this.getIsNestingComments()) {
                if (n3 + 1 < string.length() && string.charAt(n3) == '/' && string.charAt(n3 + 1) == '*') {
                    this.writeWithoutIndenting("/_*");
                    n3 += 2;
                }
                if (n3 + 1 < string.length() && string.charAt(n3) == '*' && string.charAt(n3 + 1) == '/') {
                    this.writeWithoutIndenting("*_/");
                    n3 += 2;
                }
            }
            if (this.getIsConcatenatingStrings() && n3 < string.length() && string.charAt(n3) == '\"') {
                ++n3;
                if (!this.getHasStartingQuote()) {
                    this.setHasStartingQuote();
                    this.clearHasEndingQuote();
                    this.writeWithoutIndenting("\"");
                } else if (!this.getHasEndingQuote()) {
                    this.setHasEndingQuote();
                } else {
                    System.err.println("[DataDestinationAbstractBaseClass:write]  Internal Error:  Bad state for Concatenating-Strings.");
                    this.setHasStartingQuote();
                    this.clearHasEndingQuote();
                }
            }
            if (n3 < string.length() && string.charAt(n3) == '\n') {
                this.writeNewline();
                ++n3;
                if (this.getNewlineText().length() > 0) {
                    n = 0;
                    while (n < this.getIndent()) {
                        this.writeWithoutIndenting(" ");
                        ++n;
                    }
                    this.writeWithoutIndenting(this.getNewlineText());
                    this.setNeedsToIndent(false);
                } else {
                    this.setNeedsToIndent(true);
                }
                if (this.getIsStrippingLeadingSpaces()) {
                    while (n3 < string.length() && string.charAt(n3) == ' ') {
                        ++n3;
                    }
                    if (n3 < string.length()) {
                        this.setStripLeadingSpaces(false);
                    }
                }
            }
            n2 = n3;
        }
        return this;
    }

    public void writeWithoutIndenting(String string) {
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\n' || string.charAt(n) == '\f' || string.charAt(n) == '\r') {
                this.column = 0;
                ++this.row;
            } else {
                ++this.column;
            }
            ++n;
        }
        this.length += string.length();
    }
}

