 (*************************************************************************)
 (*                                                                       *)
 (* - LEX courtesy of Dave Keiras, University of Michigan                 *)
 (*                                                                       *)
 (*                  Format  of  LEX:                                     *)
 (*            -------------------------------                            *)
 (*         Column    Data............................                    *)
 (*            1        part of speech (see key below)                    *)
 (*            2        past participle flag                              *)
 (*            3        negative flag                                     *)
 (*            4        to be flag                                        *)
 (*            5        verb + ing flag                                   *)
 (*            6        aux flag                                          *)
 (*            7-26     word (in conventional lower case spelling)        *)
 (*                                                                       *)
 (*                         Herewith a sample...                          *)
 (* Ŀ *)
 (*  B00000a               V00000abet            J00000abnormal       *)
 (*  V00000abandon         V00000abets           J00000abnormally     *)
 (*  V10000abandoned       V10000abetted         p00000aboard         *)
 (*  V00010abandoning      V00010abetting        P00000about          *)
 (*  V00000abandons        N00000abettor         p00000above          *)
 (*  V00000abbreviate      N00000abettors        N00000abrasion       *)
 (*  V10000abbreviated     N00000abilities       N00000abrasions      *)
 (*  V00000abbreviates     N00000ability         N00000abrasive       *)
 (*  V00010abbreviating    J00000able            N00000abrasives      *)
 (*  N00000abbreviation    J00000abler           N00000absence        *)
 (*  N00000abbreviations   J00000ablest          N00000absences       *)
 (*  *)
 (*                                                                       *)
 (*                        Parts of Speech Key                            *)
 (*                       ---------------------                           *)
 (* (V) verb             (q)  possessive pronoun/pronoun (e.g. "his")     *)
 (* (J) adjective        (j)  adjective/verb       (A)  adverb            *)
 (* (a) adverb/verb      (B)  article              (C)  conjunction       *)
 (* (I) interjection     (N)  noun                 (d)  noun/adjective    *)
 (* (n) noun/verb        (P)  preposition          (O)  pronoun           *)
 (* (o) adjective/pronoun (e.g. this, that)                               *)
 (* (Q) possessive pronoun (e.g. my, her, your, our, their, its)          *)
 (* (X) don't care category                                               *)
 (*     --added X category for "not" so it will not be an adverb          *)
 (* (p) preposition/adverb (e.g. aboard, above, around, as, before, below *)
 (*                                                                       *)
 (*************************************************************************)

program findverb;

{
 The LEX dictionary was compiled by Dave Keiras, of the University of
 Michigan, who has graciously made it available in the public domain.
 The grammatical markings in LEX (and the parsing theory they imply) are
 due to him; this program, on the other hand, is mine.

 This is a simple filter program operating on the LEX file.  This version
 finds verbs (i.e, lines marked with "V" in the first column). It is so
 trivial to modify this to find anything you want that, rather than add
 several hundred lines of bullet-proofing and user interface, I offer
 this commented source code file for you to fool around with.

 It is written in TurboPascal, Version 5.5, but will probably compile on
 everything from version 3 through 7 with only minor modifications,
 since it really doesn't do anything particularly complicated.

 Enjoy.

 -John Lawler
  University of Michigan
}

uses dos, crt;  {omit this statement for TurboPascal 3.x}

type column = 1..6;   { the first 6 columns of each entry,
                        where the codes are listed.  See above
                        for details of the coding }

{  change constants below  }

const { the following constants may easily be changed to search for
        different kinds of entries in different places }

      whichar : column = 1;  { which column to look for the code in; in
                               this case it's the first column.  See
                               above for other possibilities }

      whatsit : char = 'V';  { the search character to be matched in
                               column "whichar" of each line; change to
                               whatever you're looking for. See above
                               for other possibilities }

      wossname : string = ' verbs'; { the name of the key category - in
                                      the plural, with a leading space -
                                      for the final count message }

      { this is where *I* keep the files on *my* disk; change these
        paths and strings as needed for your disk. If you want to
        keep the files in the same directory as the program, just
        omit the drive and path specifications (everything up to and
        including the final "\") }

      inname  : string = 'C:\RESEARCH\KIMMO\ENGLISH\LEX';

      outname : string = 'C:\RESEARCH\KIMMO\ENGLISH\VERBS';

{  change constants above  }

const i : integer = 0; { number of matching lines found, therefore
                         the size of the output file; initialized to 0 }

var infile,            { the input file; either LEX or
                         another file structured like LEX }

    outfile : text;    { the output file - consists of whole lines
                         from the input file, therefore is a subset }

    line    : string;  { the current line; it is read from the infile and
                         written, if it matches correctly, to the outfile }
begin { code }
  assign (infile, inname);   reset   (infile);  { open source file for input }
  assign (outfile, outname); rewrite (outfile); { create file for output }
  while not eof (infile) do  { ...until you reach the end of the input file}
   begin                            { the main loop }
      readln (infile, line);            { read one line from input file }
      if line[whichar] = whatsit then   { if it matches in the right place, }
         begin inc (i);                 { add 1 to the count, and... }
               writeln (outfile, line); { ...write that line out }
         end;                           { otherwise ignore it and... }
   end;                             { ...go on to the next line }
        { then, when the input file's empty, tidy up and report }
  close (infile); close (outfile);
  writeln ('There were ', i, wossname+' in the lexicon.');
end.  { and that's all...}
