/* blowfish.c */

struct t0 {
  unsigned long P[16+2];
  unsigned long S[4][256];
};
typedef struct t0 BLOWFISH_CTX;
void Blowfish_Init (BLOWFISH_CTX *,unsigned char *,int);
void Blowfish_Encrypt (BLOWFISH_CTX *,unsigned long *,unsigned long *);
void Blowfish_Decrypt (BLOWFISH_CTX *,unsigned long *,unsigned long *);
int Blowfish_Test (BLOWFISH_CTX *);
static unsigned long F (BLOWFISH_CTX *,unsigned long);
static unsigned long const ORIG_P[16+2]={608135816,2242054355u,320440878,57701188,2752067618u,698298832,137296536,3964562569u,1160258022,953160567,3193202383u,887688300,3232508343u,3380367581u,1065670069,3041331479u,2450970073u,2306472731u};
static unsigned long const ORIG_S[4][256]={{3509652390u,2564797868u,805139163,3491422135u,3101798381u,1780907670,3128725573u,4046225305u,614570311,3012652279u,134345442,2240740374u,1667834072,1901547113,2757295779u,4103290238u,227898511,1921955416,1904987480,2182433518u,2069144605,3260701109u,2620446009u,720527379,3318853667u,677414384,3393288472u,3101374703u,2390351024u,1614419982,1822297739,2954791486u,3608508353u,3174124327u,2024746970,1432378464,3864339955u,2857741204u,1464375394,1676153920,1439316330,715854006,3033291828u,289532110,2706671279u,2087905683,3018724369u,1668267050,732546397,1947742710,3462151702u,2609353502u,2950085171u,1814351708,2050118529,680887927,999245976,1800124847,3300911131u,1713906067,1641548236,4213287313u,1216130144,1575780402,4018429277u,3917837745u,3693486850u,3949271944u,596196993,3549867205u,258830323,2213823033u,772490370,2760122372u,1774776394,2652871518u,566650946,4142492826u,1728879713,2882767088u,1783734482,3629395816u,2517608232u,2874225571u,1861159788,326777828,3124490320u,2130389656,2716951837u,967770486,1724537150,2185432712u,2364442137u,1164943284,2105845187,998989502,3765401048u,2244026483u,1075463327,1455516326,1322494562,910128902,469688178,1117454909,936433444,3490320968u,3675253459u,1240580251,122909385,2157517691u,634681816,4142456567u,3825094682u,3061402683u,2540495037u,79693498,3249098678u,1084186820,1583128258,426386531,1761308591,1047286709,322548459,995290223,1845252383,2603652396u,3431023940u,2942221577u,3202600964u,3727903485u,1712269319,422464435,3234572375u,1170764815,3523960633u,3117677531u,1434042557,442511882,3600875718u,1076654713,1738483198,4213154764u,2393238008u,3677496056u,1014306527,4251020053u,793779912,2902807211u,842905082,4246964064u,1395751752,1040244610,2656851899u,3396308128u,445077038,3742853595u,3577915638u,679411651,2892444358u,2354009459u,1767581616,3150600392u,3791627101u,3102740896u,284835224,4246832056u,1258075500,768725851,2589189241u,3069724005u,3532540348u,1274779536,3789419226u,2764799539u,1660621633,3471099624u,4011903706u,913787905,3497959166u,737222580,2514213453u,2928710040u,3937242737u,1804850592,3499020752u,2949064160u,2386320175u,2390070455u,2415321851u,4061277028u,2290661394u,2416832540u,1336762016,1754252060,3520065937u,3014181293u,791618072,3188594551u,3933548030u,2332172193u,3852520463u,3043980520u,413987798,3465142937u,3030929376u,4245938359u,2093235073,3534596313u,375366246,2157278981u,2479649556u,555357303,3870105701u,2008414854,3344188149u,4221384143u,3956125452u,2067696032,3594591187u,2921233993u,2428461,544322398,577241275,1471733935,610547355,4027169054u,1432588573,1507829418,2025931657,3646575487u,545086370,48609733,2200306550u,1653985193,298326376,1316178497,3007786442u,2064951626,458293330,2589141269u,3591329599u,3164325604u,727753846,2179363840u,146436021,1461446943,4069977195u,705550613,3059967265u,3887724982u,4281599278u,3313849956u,1404054877,2845806497u,146425753,1854211946},{1266315497,3048417604u,3681880366u,3289982499u,2909710000u,1235738493,2632868024u,2414719590u,3970600049u,1771706367,1449415276,3266420449u,422970021,1963543593,2690192192u,3826793022u,1062508698,1531092325,1804592342,2583117782u,2714934279u,4024971509u,1294809318,4028980673u,1289560198,2221992742u,1669523910,35572830,157838143,1052438473,1016535060,1802137761,1753167236,1386275462,3080475397u,2857371447u,1040679964,2145300060,2390574316u,1461121720,2956646967u,4031777805u,4028374788u,33600511,2920084762u,1018524850,629373528,3691585981u,3515945977u,2091462646,2486323059u,586499841,988145025,935516892,3367335476u,2599673255u,2839830854u,265290510,3972581182u,2759138881u,3795373465u,1005194799,847297441,406762289,1314163512,1332590856,1866599683,4127851711u,750260880,613907577,1450815602,3165620655u,3734664991u,3650291728u,3012275730u,3704569646u,1427272223,778793252,1343938022,2676280711u,2052605720,1946737175,3164576444u,3914038668u,3967478842u,3682934266u,1661551462,3294938066u,4011595847u,840292616,3712170807u,616741398,312560963,711312465,1351876610,322626781,1910503582,271666773,2175563734u,1594956187,70604529,3617834859u,1007753275,1495573769,4069517037u,2549218298u,2663038764u,504708206,2263041392u,3941167025u,2249088522u,1514023603,1998579484,1312622330,694541497,2582060303u,2151582166u,1382467621,776784248,2618340202u,3323268794u,2497899128u,2784771155u,503983604,4076293799u,907881277,423175695,432175456,1378068232,4145222326u,3954048622u,3938656102u,3820766613u,2793130115u,2977904593u,26017576,3274890735u,3194772133u,1700274565,1756076034,4006520079u,3677328699u,720338349,1533947780,354530856,688349552,3973924725u,1637815568,332179504,3949051286u,53804574,2852348879u,3044236432u,1282449977,3583942155u,3416972820u,4006381244u,1617046695,2628476075u,3002303598u,1686838959,431878346,2686675385u,1700445008,1080580658,1009431731,832498133,3223435511u,2605976345u,2271191193u,2516031870u,1648197032,4164389018u,2548247927u,300782431,375919233,238389289,3353747414u,2531188641u,2019080857,1475708069,455242339,2609103871u,448939670,3451063019u,1395535956,2413381860u,1841049896,1491858159,885456874,4264095073u,4001119347u,1565136089,3898914787u,1108368660,540939232,1173283510,2745871338u,3681308437u,4207628240u,3343053890u,4016749493u,1699691293,1103962373,3625875870u,2256883143u,3830138730u,1031889488,3479347698u,1535977030,4236805024u,3251091107u,2132092099,1774941330,1199868427,1452454533,157007616,2904115357u,342012276,595725824,1480756522,206960106,497939518,591360097,863170706,2375253569u,3596610801u,1814182875,2094937945,3421402208u,1082520231,3463918190u,2785509508u,435703966,3908032597u,1641649973,2842273706u,3305899714u,1510255612,2148256476u,2655287854u,3276092548u,4258621189u,236887753,3681803219u,274041037,1734335097,3815195456u,3317970021u,1899903192,1026095262,4050517792u,356393447,2410691914u,3873677099u,3682840055u},{3913112168u,2491498743u,4132185628u,2489919796u,1091903735,1979897079,3170134830u,3567386728u,3557303409u,857797738,1136121015,1342202287,507115054,2535736646u,337727348,3213592640u,1301675037,2528481711u,1895095763,1721773893,3216771564u,62756741,2142006736,835421444,2531993523u,1442658625,3659876326u,2882144922u,676362277,1392781812,170690266,3921047035u,1759253602,3611846912u,1745797284,664899054,1329594018,3901205900u,3045908486u,2062866102,2865634940u,3543621612u,3464012697u,1080764994,553557557,3656615353u,3996768171u,991055499,499776247,1265440854,648242737,3940784050u,980351604,3713745714u,1749149687,3396870395u,4211799374u,3640570775u,1161844396,3125318951u,1431517754,545492359,4268468663u,3499529547u,1437099964,2702547544u,3433638243u,2581715763u,2787789398u,1060185593,1593081372,2418618748u,4260947970u,69676912,2159744348u,86519011,2512459080u,3838209314u,1220612927,3339683548u,133810670,1090789135,1078426020,1569222167,845107691,3583754449u,4072456591u,1091646820,628848692,1613405280,3757631651u,526609435,236106946,48312990,2942717905u,3402727701u,1797494240,859738849,992217954,4005476642u,2243076622u,3870952857u,3732016268u,765654824,3490871365u,2511836413u,1685915746,3888969200u,1414112111,2273134842u,3281911079u,4080962846u,172450625,2569994100u,980381355,4109958455u,2819808352u,2716589560u,2568741196u,3681446669u,3329971472u,1835478071,660984891,3704678404u,4045999559u,3422617507u,3040415634u,1762651403,1719377915,3470491036u,2693910283u,3642056355u,3138596744u,1364962596,2073328063,1983633131,926494387,3423689081u,2150032023u,4096667949u,1749200295,3328846651u,309677260,2016342300,1779581495,3079819751u,111262694,1274766160,443224088,298511866,1025883608,3806446537u,1145181785,168956806,3641502830u,3584813610u,1689216846,3666258015u,3200248200u,1692713982,2646376535u,4042768518u,1618508792,1610833997,3523052358u,4130873264u,2001055236,3610705100u,2202168115u,4028541809u,2961195399u,1006657119,2006996926,3186142756u,1430667929,3210227297u,1314452623,4074634658u,4101304120u,2273951170u,1399257539,3367210612u,3027628629u,1190975929,2062231137,2333990788u,2221543033u,2438960610u,1181637006,548689776,2362791313u,3372408396u,3104550113u,3145860560u,296247880,1970579870,3078560182u,3769228297u,1714227617,3291629107u,3898220290u,166772364,1251581989,493813264,448347421,195405023,2709975567u,677966185,3703036547u,1463355134,2715995803u,1338867538,1343315457,2802222074u,2684532164u,233230375,2599980071u,2000651841,3277868038u,1638401717,4028070440u,3237316320u,6314154,819756386,300326615,590932579,1405279636,3267499572u,3150704214u,2428286686u,3959192993u,3461946742u,1862657033,1266418056,963775037,2089974820,2263052895u,1917689273,448879540,3550394620u,3981727096u,150775221,3627908307u,1303187396,508620638,2975983352u,2726630617u,1817252668,1876281319,1457606340,908771278,3720792119u,3617206836u,2455994898u,1729034894,1080033504},{976866871,3556439503u,2881648439u,1522871579,1555064734,1336096578,3548522304u,2579274686u,3574697629u,3205460757u,3593280638u,3338716283u,3079412587u,564236357,2993598910u,1781952180,1464380207,3163844217u,3332601554u,1699332808,1393555694,1183702653,3581086237u,1288719814,691649499,2847557200u,2895455976u,3193889540u,2717570544u,1781354906,1676643554,2592534050u,3230253752u,1126444790,2770207658u,2633158820u,2210423226u,2615765581u,2414155088u,3127139286u,673620729,2805611233u,1269405062,4015350505u,3341807571u,4149409754u,1057255273,2012875353,2162469141u,2276492801u,2601117357u,993977747,3918593370u,2654263191u,753973209,36408145,2530585658u,25011837,3520020182u,2088578344,530523599,2918365339u,1524020338,1518925132,3760827505u,3759777254u,1202760957,3985898139u,3906192525u,674977740,4174734889u,2031300136,2019492241,3983892565u,4153806404u,3822280332u,352677332,2297720250u,60907813,90501309,3286998549u,1016092578,2535922412u,2839152426u,457141659,509813237,4120667899u,652014361,1966332200,2975202805u,55981186,2327461051u,676427537,3255491064u,2882294119u,3433927263u,1307055953,942726286,933058658,2468411793u,3933900994u,4215176142u,1361170020,2001714738,2830558078u,3274259782u,1222529897,1679025792,2729314320u,3714953764u,1770335741,151462246,3013232138u,1682292957,1483529935,471910574,1539241949,458788160,3436315007u,1807016891,3718408830u,978976581,1043663428,3165965781u,1927990952,4200891579u,2372276910u,3208408903u,3533431907u,1412390302,2931980059u,4132332400u,1947078029,3881505623u,4168226417u,2941484381u,1077988104,1320477388,886195818,18198404,3786409000u,2509781533u,112762804,3463356488u,1866414978,891333506,18488651,661792760,1628790961,3885187036u,3141171499u,876946877,2693282273u,1372485963,791857591,2686433993u,3759982718u,3167212022u,3472953795u,2716379847u,445679433,3561995674u,3504004811u,3574258232u,54117162,3331405415u,2381918588u,3769707343u,4154350007u,1140177722,4074052095u,668550556,3214352940u,367459370,261225585,2610173221u,4209349473u,3468074219u,3265815641u,314222801,3066103646u,3808782860u,282218597,3406013506u,3773591054u,379116347,1285071038,846784868,2669647154u,3771962079u,3550491691u,2305946142u,453669953,1268987020,3317592352u,3279303384u,3744833421u,2610507566u,3859509063u,266596637,3847019092u,517658769,3462560207u,3443424879u,370717030,4247526661u,2224018117u,4143653529u,4112773975u,2788324899u,2477274417u,1456262402,2901442914u,1517677493,1846949527,2295493580u,3734397586u,2176403920u,1280348187,1908823572,3871786941u,846861322,1172426758,3287448474u,3383383037u,1655181056,3139813346u,901632758,1897031941,2986607138u,3066810236u,3447102507u,1393639104,373351379,950779232,625454576,3124240540u,4148612726u,2007998917,544563296,2244738638u,2330496472u,2058025392,1291430526,424198748,50039436,29584100,3605783033u,2429876329u,2791104160u,1057563949,3255363231u,3075367218u,3463963227u,1469046755,985887462}};
unsigned long F (BLOWFISH_CTX *ctx,unsigned long x)
{
  unsigned short a;
  unsigned short b;
  unsigned short c;
  unsigned short d;
  unsigned long y;
  d = (x&255);
  x>>=8;
  c = (x&255);
  x>>=8;
  b = (x&255);
  x>>=8;
  a = (x&255);
  y = ((ctx->S)[0][a]+(ctx->S)[1][b]);
  y = (y^(ctx->S)[2][c]);
  y = (y+(ctx->S)[3][d]);
  return y;
}
void Blowfish_Encrypt (BLOWFISH_CTX *ctx,unsigned long *xl,unsigned long *xr)
{
  unsigned long Xl;
  unsigned long Xr;
  unsigned long temp;
  short i;
  Xl = (*xl);
  Xr = (*xr);
  for (i = 0; i<16; i++)
    {
      Xl = (Xl^(ctx->P)[i]);
      Xr = (F (ctx,Xl)^Xr);
      temp = Xl;
      Xl = Xr;
      Xr = temp;
    }
  temp = Xl;
  Xl = Xr;
  Xr = temp;
  Xr = (Xr^(ctx->P)[16]);
  Xl = (Xl^(ctx->P)[16+1]);
  *xl = Xl;
  *xr = Xr;
}
void Blowfish_Decrypt (BLOWFISH_CTX *ctx,unsigned long *xl,unsigned long *xr)
{
  unsigned long Xl;
  unsigned long Xr;
  unsigned long temp;
  short i;
  Xl = (*xl);
  Xr = (*xr);
  for (i = (16+1); i>1; i--)
    {
      Xl = (Xl^(ctx->P)[i]);
      Xr = (F (ctx,Xl)^Xr);
      temp = Xl;
      Xl = Xr;
      Xr = temp;
    }
  temp = Xl;
  Xl = Xr;
  Xr = temp;
  Xr = (Xr^(ctx->P)[1]);
  Xl = (Xl^(ctx->P)[0]);
  *xl = Xl;
  *xr = Xr;
}
void Blowfish_Init (BLOWFISH_CTX *ctx,unsigned char *key,int keyLen)
{
  int i;
  int j;
  int k;
  unsigned long data;
  unsigned long datal;
  unsigned long datar;
  for (i = 0; i<4; i++)
    {
      for (j = 0; j<256; j++)
        ctx->S[i][j] = ORIG_S[i][j];
    }
  j = 0;
  for (i = 0; i<(16+2); i++)
    {
      data = 0;
      for (k = 0; k<4; k++)
        {
          data = ((data<<8)|key[j]);
          j = (j+1);
          if (j>=keyLen) 
            j = 0;
        }
      ctx->P[i] = (ORIG_P[i]^data);
    }
  datal = 0;
  datar = 0;
  for (i = 0; i<(16+2); i+=2)
    {
      Blowfish_Encrypt (ctx,&datal,&datar);
      ctx->P[i] = datal;
      ctx->P[i+1] = datar;
    }
  for (i = 0; i<4; i++)
    {
      for (j = 0; j<256; j+=2)
        {
          Blowfish_Encrypt (ctx,&datal,&datar);
          ctx->S[i][j] = datal;
          ctx->S[i][j+1] = datar;
        }
    }
}
int Blowfish_Test (BLOWFISH_CTX *ctx)
{
  unsigned long L=1;
  unsigned long R=2;
  Blowfish_Init (ctx,(unsigned char *) "TESTKEY",7);
  Blowfish_Encrypt (ctx,&L,&R);
  if ((L!=3744677842u)||(R!=816257972)) 
    return -1;
  Blowfish_Decrypt (ctx,&L,&R);
  if ((L!=1)||(R!=2)) 
    return -1;
  return 0;
}
