(* CTT by Jonathan Baccash *)
signature CTT =
sig
  (* Print translation.  Argument is an input file name. *)
  val cte : string -> unit
  val etc : string -> unit
  val ctc : string -> unit
  val ete : string -> unit

  (* Print translation.  Arguments are input file name, output file name. *)
  val cte2 : (string * string) -> unit
  val etc2 : (string * string) -> unit
  val ctc2 : (string * string) -> unit
  val ete2 : (string * string) -> unit

  (* Print translation.  Used for export. *)
  val c2e : (string * string list) -> OS.Process.status
  val e2c : (string * string list) -> OS.Process.status

  (* Pretty print C file *)
  val c2c : (string * string list) -> OS.Process.status
end
