
structure NatStuff =
   struct

      datatype nat = Z of unit | S of nat

      datatype list = Nil of unit | Cons of nat * list

      val foo =
         (case (1, 2) of
             (x, y) => y)

      fun add (xy : nat * nat) : nat =
          (case xy of
              (Z (), y) => y
            | (S x', y) => S (add (x', y)))

      fun addlist (l : list) : nat =
          (case l of
              Nil () => Z ()
            | Cons (h, t) => add (h, addlist t))

   end
   :>
   sig
      datatype nat = Z of unit | S of nat
      datatype list = Nil of unit | Cons of nat * list
      val add : nat * nat -> nat
      val addlist : list -> nat
   end


open NatStuff

val x = addlist (Cons (Z (), Cons (S (Z ()), Nil ())))


structure Foo =
   struct
      type t = NatStuff.nat
      val x = Z ()
   end
   :
   sig
      type t
      val x : t
   end


val y = add (Foo.x, Z ())


structure Bar =
   struct
      structure S1 =
         struct
            type t = nat
         end

      structure S2 =
         struct
            val x = Z ()
         end
   end
   :>
   sig
      structure S1 :
         sig
            type t
         end

      structure S2 :
         sig
            val x : S1.t
         end
   end


val z =
   let val w = S x
   in
      add (w, w)
   end


val l =
   let
      fun countdown (n : nat) : list =
          (case n of
              Z () =>
                 Nil ()
            | S n' =>
                 Cons (n', countdown n'))
   in
      countdown z
   end


val g =
   let type t = nat
   in
      fn x : t => ()
   end


fun fact (n : int) : int =
    (case n of
        0 => 1
      | n => n * fact (n-1))

fun natToInt (n : nat) : int =
    (case n of
        Z () => 0
      | S n' => 1 + natToInt n')
    
val () = print (Int.toString (natToInt z) ^ "\n")

val one = 1

local
   val one = S (Z ())
in
   val one' = natToInt one
end

val two = one + one'

local
   datatype foo = C of unit
in
   val bar = C ()
end

