
structure SubstModule :> SUBST_MODULE 
   =
   struct

      open ILModule

      (* substXMain m s n l exp 
       
         if    |s| = n
         then  return exp[0 .. m-1 . s0[^m] .. sn-1[^m] . ^l+m]
      *)

      fun substKindMain m s n l k =
         (case k of
             Ktype => k
           | Ksing c =>
                Ksing (substConMain m s n l c)
           | Kpi (k1, k2) =>
                Kpi (substKindMain m s n l k1, substKindMain (m+1) s n l k2)
           | Ksigma (k1, k2) =>
                Ksigma (substKindMain m s n l k1, substKindMain (m+1) s n l k2)
           | Kunit => k)

      and substConMain m s n l c =
         (case c of
             Cvar (i, NONE) =>
                if i < m then
                   c
                else if i < m+n then
                   substConMain 0 [] 0 m (List.nth (s, i-m))
                else
                   Cvar (i-n+l, NONE)
           | Cvar (i, SOME j) =>
                if i < m then
                   Cvar (i, SOME (j-n+l))
                else if i < m+n then
                   substConMain 0 [] 0 m (List.nth (s, i-m))
                else
                   Cvar (i-n+l, SOME (j-n+l))
           | Clam (k, c) =>
                Clam (substKindMain m s n l k, substConMain (m+1) s n l c)
           | Capp (c1, c2) =>
                Capp (substConMain m s n l c1, substConMain m s n l c2)
           | Cpair (c1, c2) =>
                Cpair (substConMain m s n l c1, substConMain m s n l c2)
           | Cpi1 c =>
                Cpi1 (substConMain m s n l c)
           | Cpi2 c =>
                Cpi2 (substConMain m s n l c)
           | Cunit => c
           | Carrow (c1, c2) =>
                Carrow (substConMain m s n l c1, substConMain m s n l c2)
           | Cprod cl =>
                Cprod (map (substConMain m s n l) cl)
           | Csum cl =>
                Csum (map (substConMain m s n l) cl)
           | Crec c =>
                Crec (substConMain (m+1) s n l c)
           | Ctag c =>
                Ctag (substConMain m s n l c)
           | Cref c =>
                Cref (substConMain m s n l c)
           | Cexn => c
           | Cbool => c
           | Cint => c
           | Cchar => c
           | Cstring => c)

      fun substSgMain m s n l sg =
         (case sg of
             Sval c =>
                Sval (substConMain m s n l c)
           | Scon k =>
                Scon (substKindMain m s n l k)
           | Ssigma (sg1, sg2) =>
                Ssigma (substSgMain m s n l sg1, substSgMain (m+1) s n l sg2)
           | Spi (sg1, sg2) =>
                Spi (substSgMain m s n l sg1, substSgMain (m+1) s n l sg2)
           | Sunit => Sunit
           | Snamed (name, sg') =>
                Snamed (name, substSgMain m s n l sg'))

      fun substTermMain m s n l e =
         (case e of
             Tvar _ => e
           | Tlam (v, c, e') =>
                Tlam (v, substConMain m s n l c, substTermMain m s n l e')
           | Tapp (e1, e2) =>
                Tapp (substTermMain m s n l e1, substTermMain m s n l e2)
           | Ttuple el =>
                Ttuple (map (substTermMain m s n l) el)
           | Tproj (e', i) =>
                Tproj (substTermMain m s n l e', i)
           | Tinj (e', i, c) =>
                Tinj (substTermMain m s n l e', i, substConMain m s n l c)
           | Tcase (e', arms) =>
                Tcase (substTermMain m s n l e', map (fn (vi, ei) => (vi, substTermMain m s n l ei)) arms)
           | Troll (e', c) =>
                Troll (substTermMain m s n l e', substConMain m s n l c)
           | Tunroll e' =>
                Tunroll (substTermMain m s n l e')
           | Ttag (e1, e2) =>
                Ttag (substTermMain m s n l e1, substTermMain m s n l e2)
           | Tiftag (e1, e2, v, e3, e4) =>
                Tiftag (substTermMain m s n l e1, substTermMain m s n l e2, v, substTermMain m s n l e3, substTermMain m s n l e4)
           | Tnewtag c =>
                Tnewtag (substConMain m s n l c)
           | Traise (e', c) =>
                Traise (substTermMain m s n l e', substConMain m s n l c)
           | Thandle (e1, v, e2) =>
                Thandle (substTermMain m s n l e1, v, substTermMain m s n l e2)
           | Tref e' =>
                Tref (substTermMain m s n l e')
           | Tderef e' =>
                Tderef (substTermMain m s n l e')
           | Tassign (e1, e2) =>
                Tassign (substTermMain m s n l e1, substTermMain m s n l e2)
           | Tbool _ => e
           | Tif (e1, e2, e3) =>
                Tif (substTermMain m s n l e1, substTermMain m s n l e2, substTermMain m s n l e3)
           | Tint _ => e
           | Tchar _ => e
           | Tstring _ => e
           | Tlet (v, e1, e2) =>
                Tlet (v, substTermMain m s n l e1, substTermMain m s n l e2)
           | Tletm (v, md, e', c) =>
                Tletm (v, substModuleMain m s n l md, substTermMain (m+1) s n l e', substConMain m s n l c)
           | Tprim (prim, el) =>
                Tprim (prim, map (substTermMain m s n l) el)
           | Tsnd md =>
                Tsnd (substModuleMain m s n l md))

      and substModuleMain m s n l md =
         (case md of
             Mvar _ => md
           | Mval e =>
                Mval (substTermMain m s n l e)
           | Mcon c =>
                Mcon (substConMain m s n l c)
           | Munit => md
           | Mpair (md1, md2) =>
                Mpair (substModuleMain m s n l md1, substModuleMain m s n l md2)
           | Mdpair (v, md1, md2) =>
                Mdpair (v, substModuleMain m s n l md1, substModuleMain (m+1) s n l md2)
           | Mpi1 md' =>
                Mpi1 (substModuleMain m s n l md')
           | Mpi2 md' =>
                Mpi2 (substModuleMain m s n l md')
           | Mlam (v, sg, md') =>
                Mlam (v, substSgMain m s n l sg, substModuleMain (m+1) s n l md')
           | Mapp (md1, md2) =>
                Mapp (substModuleMain m s n l md1, substModuleMain m s n l md2)
           | Min (name, md') =>
                Min (name, substModuleMain m s n l md')
           | Mout md' =>
                Mout (substModuleMain m s n l md')
           | Mlet (v, md1, md2, sg) =>
                Mlet (v, substModuleMain m s n l md1, substModuleMain (m+1) s n l md2, substSgMain m s n l sg)
           | Mletd (v, md1, md2) =>
                Mletd (v, substModuleMain m s n l md1, substModuleMain (m+1) s n l md2)
           | Mlete (v, e, md') =>
                Mlete (v, substTermMain m s n l e, substModuleMain m s n l md')
           | Mseal (md', sg) =>
                Mseal (substModuleMain m s n l md', substSgMain m s n l sg))

      fun substKindGen m s l k =
         let
            val n = length s
         in
            if n = 0 andalso l = 0 then
               k
            else
               substKindMain m s n l k
         end

      fun substConGen m s l c =
         let
            val n = length s
         in
            if n = 0 andalso l = 0 then
               c
            else
               substConMain m s n l c
         end

      fun substSgGen m s l sg =
         let
            val n = length s
         in
            if n = 0 andalso l = 0 then
               sg
            else
               substSgMain m s n l sg
         end

      fun substTermGen m s l e =
         let
            val n = length s
         in
            if n = 0 andalso l = 0 then
               e
            else
               substTermMain m s n l e
         end

      fun substModuleGen m s l md =
         let
            val n = length s
         in
            if n = 0 andalso l = 0 then
               md
            else
               substModuleMain m s n l md
         end

      fun liftKind l exp =
         if l = 0 then
            exp
         else
            substKindMain 0 [] 0 l exp

      fun liftCon l exp =
         if l = 0 then
            exp
         else
            substConMain 0 [] 0 l exp

      fun liftSg l exp =
         if l = 0 then
            exp
         else
            substSgMain 0 [] 0 l exp

      fun liftTerm l exp =
         if l = 0 then
            exp
         else
            substTermMain 0 [] 0 l exp

      fun liftModule l exp =
         if l = 0 then
            exp
         else
            substModuleMain 0 [] 0 l exp

      fun substKind s exp = substKindMain 0 [s] 1 0 exp
      fun substCon s exp = substConMain 0 [s] 1 0 exp
      fun substSg s exp = substSgMain 0 [s] 1 0 exp
      fun substTerm s exp = substTermMain 0 [s] 1 0 exp
      fun substModule s exp = substModuleMain 0 [s] 1 0 exp

   end
