
signature SUBST_MODULE =
   sig

      type kind = ILModule.kind
      type con = ILModule.con
      type sg = ILModule.sg
      type term = ILModule.term
      type module = ILModule.module

      (* For X in {Kind, Con, Sg, Term, Module}:
         substXGen m [s0, .. sn-1] l exp = exp[0 .. m-1 . s0[^m] .. sn-1[^m] . ^l+m]
      *)

      val substKindGen : int -> con list -> int -> kind -> kind
      val substConGen : int -> con list -> int -> con -> con
      val substSgGen : int -> con list -> int -> sg -> sg
      val substTermGen : int -> con list -> int -> term -> term
      val substModuleGen : int -> con list -> int -> module -> module

      val liftKind : int -> kind -> kind
      val liftCon : int -> con -> con
      val liftSg : int -> sg -> sg
      val liftTerm : int -> term -> term
      val liftModule : int -> module -> module

      val substKind : con -> kind -> kind
      val substCon : con -> con -> con
      val substSg : con -> sg -> sg
      val substTerm : con -> term -> term
      val substModule : con -> module -> module

   end
