
signature SUBST_HOIST =
   sig

      type kind = ILHoist.kind
      type con = ILHoist.con
      type exp = ILHoist.exp
      type value = ILHoist.value
      type function = ILHoist.function
      type program = ILHoist.program
      
      (* For X in {Kind, Con, Exp, Value, Function, Program}:
         substXGen m [s0, .. sn-1] l exp = exp[0 .. m-1 . s0[^m] .. sn-1[^m] . ^l+m]

         For X in {Exp, Value, Function, Program}
         If    d = v0 |-> e0 .. vp-1 |-> ep-1
         then  dsubstXGen m [s0, .. sn-1] l d e
               = [e0[^m] .. ep-1[^m] / v0 .. vp-1] (e[0 .. m-1 . s0[^m] .. sn-1[^m] . ^l+m])
      *)

      val substKindGen : int -> con list -> int -> kind -> kind
      val substConGen : int -> con list -> int -> con -> con
      val substExpGen : int -> con list -> int -> exp -> exp
      val substValueGen : int -> con list -> int -> value -> value
      val substFunctionGen : int -> con list -> int -> function -> function
      val substProgramGen : int -> con list -> int -> program -> program
      val dsubstExpGen : int -> con list -> int -> value VariableDict.dict -> exp -> exp
      val dsubstValueGen : int -> con list -> int -> value VariableDict.dict -> value -> value
      val dsubstFunctionGen : int -> con list -> int -> value VariableDict.dict -> function -> function
      val dsubstProgramGen : int -> con list -> int -> value VariableDict.dict -> program -> program

      val liftKind : int -> kind -> kind
      val liftCon : int -> con -> con
      val liftExp : int -> exp -> exp
      val liftValue : int -> value -> value
      val liftFunction : int -> function -> function
      val liftProgram : int -> program -> program

      val substKind : con -> kind -> kind
      val substCon : con -> con -> con
      val substExp : con -> exp -> exp
      val substValue : con -> value -> value
      val substFunction : con -> function -> function
      val substProgram : con -> program -> program

   end
