
signature INSPECT_HOIST =
   sig

      include INSPECT

      type kind = ILHoist.kind
      type con = ILHoist.con
      type exp = ILHoist.exp
      type value = ILHoist.value
      type function = ILHoist.function
      type program = ILHoist.program
      
      val loadKind : kind -> unit
      val loadCon : con -> unit
      val loadExp : exp -> unit
      val loadValue : value -> unit
      val loadFunction : function -> unit
      val loadProgram : program -> unit

      val extractKind : unit -> kind
      val extractCon : unit -> con
      val extractExp : unit -> exp
      val extractValue : unit -> value
      val extractFunction : unit -> function
      val extractProgram : unit -> program

      val suppressCon : bool ref

   end
