
structure Resolve :> RESOLVE =
   struct

      open ILModule
      open SubstModule

      fun eqName n1 n2 =
         (case (n1, n2) of
             (VAL s1, VAL s2) => s1 = s2
           | (CON s1, CON s2) => s1 = s2
           | (MOD s1, MOD s2) => s1 = s2
           | (DT s1, DT s2) => s1 = s2
           | _ => false)

      fun searchable n =
         (case n of
             DT _ => true
           | _ => false)

      type namespace = string -> name
      type elabctx = ILModule.con * ILModule.module * ILModule.sg

      exception Resolve


      fun cproj1 c =
         (case c of
             Cpair (c1, c2) => c1
           | _ => Cpi1 c)

      fun cproj2 c =
         (case c of
             Cpair (c1, c2) => c2
           | _ => Cpi2 c)

      fun mproj1 m =
         (case m of
             Mpair (m1, m2) =>
                (* Our invariant provides that m2 has no side-effects. *)
                m1
           | _ =>
                Mpi1 m)

      fun mproj2 m =
         (case m of
             Mpair (m1, m2) =>
                (* Our invariant provides that m1 has no side-effects. *)
                m2
           | _ =>
                Mpi2 m)

      fun mout m =
         (case m of
             Min (_, m') => m'
           | _ =>
                Mout m)

      (* resolve1Main C M S sub name
       
         Suppose G |- S[sub] : sig
                 G |-p M : S
                 G |- Fst(M) >> C
                 M is valuable
         then    if    name resolves in S[sub]
                 then  G |- S' : sig
                       G |- M' : S'
                       G |- Fst(M') >> C'
                       and
                       return (C', M', S')
                 else  raise Resolve
      *)
      fun resolve1Main c m sg sub name =
         (case sg of
             Snamed (name', sg') =>
                if eqName name name' then
                   (c, mout m, substSgGen 0 sub 0 sg')
                else if searchable name' then
                   resolve1Main c (mout m) sg' sub name
                else
                   raise Resolve
           | Ssigma (sg1, sg2) =>
                (resolve1Main (cproj2 c) (mproj2 m) sg2 (Cpi1 c :: sub) name
                 handle Resolve =>
                           resolve1Main (cproj1 c) (mproj1 m) sg1 sub name)
           | _ =>
                raise Resolve)

      fun resolve1 (c, m, sg) name = resolve1Main c m sg [] name

      fun resolve c_m_sg ns longid =
         (case longid of
             nil =>
                (* longids must be nonempty *)
                raise (Fail "invariant")
           | [id] =>
                resolve1 c_m_sg (ns id)
           | id :: rest =>
                let val c_m_sg' = resolve1 c_m_sg (MOD id)
                in
                   resolve c_m_sg' ns rest
                end)

      fun liftElabctx n (c, m, sg) =
         (liftCon n c, liftModule n m, liftSg n sg)

      fun append (c1, m1, sg1) (c2, m2, sg2) =
         (Cpair (c1, c2),
          Mpair (m1, m2),
          Ssigma (sg1, SubstModule.liftSg 1 sg2))

   end
