
signature RESOLVE =
   sig

      type namespace = string -> ILModule.name
      type elabctx = ILModule.con * ILModule.module * ILModule.sg

      exception Resolve

      (* M is _valuable_ if it satisfies the grammar:

         Mv ::= v
              | <| x |>
              | (| C |)
              | < Mv, Mv >
              | pi1 Mv
              | pi2 Mv
              | out Mv
              | in Mv
      *)

      (* resolve1 (C, M, S) name
       
         Suppose G |- S : sig
                 G |-p M : S
                 G |- Fst(M) >> C
                 M is valuable
         then    if    name resolves in S
                 then  G |- S' : sig
                       G |-p M' : S'
                       G |- Fst(M') >> C'
                       M' is valuable
                       and
                       return (C', M', S')
                 else  raise Resolve
      *)
      val resolve1 : elabctx -> ILModule.name -> elabctx

      (* resolve (C, M, S) ns id
       
         Suppose G |- S : sig
                 G |-p M : S
                 G |- Fst(M) >> C
                 M is valuable
         then    if    ns(id) resolves in S
                 then  G |- S' : sig
                       G |-p M' : S'
                       G |- Fst(M') >> C'
                       M' is valuable
                       and
                       return (C', M', S')
                 else  raise Resolve
      *)
      val resolve : elabctx -> namespace -> EL.longid -> elabctx

      val liftElabctx : int -> elabctx -> elabctx

      (* append (C1, M1, S1) (C2, M2, S2) = (<C1, C2>, <M1, M2>, (S1 * S2)) *)
      val append : elabctx -> elabctx -> elabctx

   end
