
structure ElaborateType :> ELABORATE_TYPE =
   struct

      open ILModule
      open SubstModule
      open ContextModule
      open CompactModule

      type context = ContextModule.context
      type elabctx = ILModule.con * ILModule.module * ILModule.sg

      exception TypeError = Misc.TypeError

      fun elabTp ctx ectx tp =
         (case tp of
             EL.Cident longid =>
                let val (c, _, sg) = 
                       Resolve.resolve ectx CON longid
                       handle Resolve.Resolve => raise TypeError
                in
                   (case sg of
                       Scon k =>
                          (
                          EquivModule.subkind ctx k Ktype;
                          c
                          )
                     | _ =>
                          raise TypeError)
                end

           | EL.Carrow (dom, cod) =>
                Carrow (elabTp ctx ectx dom, elabTp ctx ectx cod)

           | EL.Cprod tl =>
                Cprod (map (elabTp ctx ectx) tl)

           | EL.Cbool => Cbool
           | EL.Cint => Cint
           | EL.Cchar => Cchar
           | EL.Cstring => Cstring)

      val dummy = Variable.newvar ()

      fun elabDatatype ctx ectx idDt dcons =
         let
            val vFwd = Variable.newvar ()

            val ctx' = extendSg ctx vFwd (Snamed (CON idDt, Scon Ktype))

            val zero =
               compactCon
               (Cvar (0, SOME (ksize ctx')))

            val ectx' =
               Resolve.append
                  (Resolve.liftElabctx 1 ectx)
                  (zero, Mvar vFwd, Snamed (CON idDt, Scon Ktype))

            val n = length dcons

            val dcons' =
               map
               (fn (id, tp) => (id, compactCon (elabTp ctx' ectx' tp)))
               dcons
            
            (* Let sgFwd = CON(idDt):(| Type |) and note that Fst(sgFwd) = Type *)
            val cl = map #2 dcons'                   (* G, sgFwd |- ci : Type   (for each i) *)
            val csum = compactCon (Csum cl)          (* G, sgFwd |- csum : Type *)
            val cfull = Crec csum                    (* G        |- cfull : Type *)

            (* intfLoop depth l = sg

               G, sgFwd, Gd |- sg : sig    where |Gd| = depth

               (We pass in the depth to avoid the cost of lifting the tail over and over again.)
            *)
            fun intfLoop depth l =
               (case l of
                   [] =>
                      Sunit
                 | (id, c) :: rest =>
                      let
                         (* G, sgFwd |- c : Type *)
                         val c' = liftCon depth c

                         val cdepth = Cvar (depth, SOME (depth + ksize ctx'))
                      in
                         Ssigma
                            (Snamed (VAL id,
                                     Snamed (DCON,
                                             Sval (Cprod [Carrow (c', cdepth),
                                                          Carrow (cdepth,
                                                                  Csum [Cprod [], c'])]))),
                             intfLoop (depth+1) rest)
                      end)

            val sg =
               CompactModule.compactSg
               (Ssigma (Snamed (CON idDt, Scon Ktype),
                        intfLoop 0 dcons'))

            (* implLoop arm l = m
             
               G, sgFwd |- m : sg  where  sg = intfLoop 0 l
            *)
            fun implLoop arm l =
               (case l of
                   [] =>
                      Munit
                 | (id, c) :: rest =>
                      let
                         val v = Variable.newvar ()

                         val annot = compactCon (Csum [Cprod [], c])

                         fun implCases curr =
                            if curr = n then
                               []
                            else 
                               (if curr = arm then
                                   let
                                      val v = Variable.newvar ()
                                   in
                                      (v, Tinj (Tvar v, 1, annot))
                                   end
                                else
                                   (dummy, Tinj (Ttuple [], 0, annot)))
                               ::
                               implCases (curr+1)
                         
                      in
                         Mpair
                            (Min (VAL id,
                                  Min (DCON,
                                       Mval (Ttuple [
                                                    Tlam (v, c,
                                                          Troll (Tinj (Tvar v, arm, csum), zero)),
                                                    Tlam (v, zero,
                                                          Tcase (Tunroll (Tvar v), implCases 0))
                                                    ]))),
                             implLoop (arm+1) rest)
                      end)

            val m =
               Mdpair (vFwd,
                       Min (CON idDt, Mcon cfull),
                       implLoop 0 dcons')

         in
            (Snamed (DT idDt, sg),
             Min (DT idDt, Mseal (m, sg)))
         end
                   


      fun elabSpec ctx ectx spec =
         (case spec of
             EL.Sval (id, tp) =>
                let val c = elabTp ctx ectx tp
                in
                   Snamed (VAL id, Sval c)
                end

           | EL.Stype id =>
                Snamed (CON id, Scon Ktype)

           | EL.Stypeeq (id, tp) =>
                let val c = elabTp ctx ectx tp
                in
                   Snamed (CON id, Scon (Ksing c))
                end

           | EL.Smodule (id, sg) =>
                let val sg' = elabSg ctx ectx sg
                in
                   Snamed (MOD id, sg')
                end

           | EL.Sdata (id, dcons) =>
                let val (sg, _) = elabDatatype ctx ectx id dcons
                in
                   sg
                end)

      and elabSg ctx ectx specs =
         (case specs of
             nil =>
                Sunit

           | spec :: rest =>
                let 
                   val sg = elabSpec ctx ectx spec

                   (* We will never refer to the dynamic portion of this binding,
                      can just use a dummy variable.
                   *)
                   val ctx' = extendSg ctx dummy sg

                   val ectx' =
                      Resolve.append
                      (Resolve.liftElabctx 1 ectx)
                      (Cvar (0, SOME (ksize ctx')), Mvar dummy, liftSg 1 sg)
                in
                   Ssigma (sg, elabSg ctx' ectx' rest)
                end)

  end
