
structure ElaboratePrim :> ELABORATE_PRIM =
   struct

      open ILModule
      open CompactModule

      fun unary dom cod prim =
         let 
            val v = Variable.newvar ()
         in
            (compactCon (Carrow (dom, cod)),
             Tlam (v, compactCon dom, Tprim (prim, [Tvar v])))
         end

      fun binary dom cod prim =
         let 
            val v = Variable.newvar ()
         in
            (compactCon (Carrow (Cprod [dom, dom], cod)),
             Tlam (v,
                   compactCon (Cprod [dom, dom]),
                   Tprim (prim, [Tproj (Tvar v, 0), Tproj (Tvar v, 1)])))
         end

      val neg = unary Cint Cint Prim.Neg
      val plus = binary Cint Cint Prim.Plus
      val minus = binary Cint Cint Prim.Minus
      val times = binary Cint Cint Prim.Times
      val intToString = unary Cint Cstring Prim.IntToString
      val concat = binary Cstring Cstring Prim.Concat
      val print = unary Cstring (Cprod []) Prim.Print

      fun elabPrim prim =
         (case prim of
             ELPrim.Neg => neg
           | ELPrim.Plus => plus
           | ELPrim.Minus => minus
           | ELPrim.Times => times
           | ELPrim.IntToString => intToString
           | ELPrim.Concat => concat
           | ELPrim.Print => print)

   end