
signature ASCRIBE =
   sig

      type context = ContextModule.context

      (* ascribe G M S1 S2 opacity

         Suppose G |- M : S1
         and     G |- S2 : sig
                 S2 contains only ascribeable names
         then    returns (S, M')
                 where
                 G |- M' : S  (not necessarily determinate, even if M is)
                 G |- S <: S2
                 or
                 raises Misc.TypeError

         Where ascribeable names are VAL _, CON _, MOD _, and DT _.
      *)
      val ascribe : context -> ILModule.module -> ILModule.sg -> ILModule.sg -> EL.opacity -> ILModule.sg * ILModule.module

   end
