
(* Use transparent ascription for ease of debugging. *)
structure Variable : VARIABLE =
   struct

      type variable = int

      val nextvar = ref 0
      fun newvar () =
          let val v = !nextvar
          in
             nextvar := v+1;
             v
          end

      fun eq (v1 : variable, v2) = v1 = v2

      val compare = Int.compare

   end


structure VariableOrdered 
   :> ORDERED
      where type t = Variable.variable
   =
   struct
      type t = Variable.variable
      val eq = Variable.eq
      val compare = Variable.compare
   end


structure VariableDict = SplayDict (structure Key = VariableOrdered)
structure VariableSet = SplaySet (structure Elem = VariableOrdered)
