
structure Printer : sig val printer : (string -> unit) ref end =
   struct
      val printer = ref TextIO.print
   end


functor PrimEvalFun (structure Param : PRIM_EVAL_PARAM)
   :>
   PRIM_EVAL
   where type result = Param.result
   =
   struct

      open Prim
      open Param

      type result = Param.result

      fun primInt f rl =
          (case map destRint rl of
              [SOME x] =>
                 f x
            | _ =>
                 raise Wrong)

      fun primInt2 f rl =
          (case map destRint rl of
              [SOME x, SOME y] =>
                 f (x, y)
            | _ =>
                 raise Wrong)

      fun primChar2 f rl =
          (case map destRchar rl of
              [SOME x, SOME y] =>
                 f (x, y)
            | _ =>
                 raise Wrong)

      fun primString f rl =
          (case map destRstring rl of
              [SOME x] =>
                 f x
            | _ =>
                 raise Wrong)

      fun primString2 f rl =
          (case map destRstring rl of
              [SOME x, SOME y] =>
                 f (x, y)
            | _ =>
                 raise Wrong)

      fun primeval prim =
          (case prim of
              Neg =>
                 primInt (fn x => Rint (~x))
            | Plus =>
                 primInt2 (fn (x, y) => Rint (x + y))
            | Minus =>
                 primInt2 (fn (x, y) => Rint (x - y))
            | Times =>
                 primInt2 (fn (x, y) => Rint (x * y))
            | Div =>
                 primInt2 (fn (x, y) => Rint (x div y))
            | Mod =>
                 primInt2 (fn (x, y) => Rint (x mod y))
            | EqInt =>
                 primInt2 (fn (x, y) => Rbool (x = y))
            | LtInt =>
                 primInt2 (fn (x, y) => Rbool (x < y))
            | LeqInt =>
                 primInt2 (fn (x, y) => Rbool (x <= y))
            | IntToString =>
                 primInt (fn x => Rstring (Int.toString x))
            | EqChar =>
                 primChar2 (fn (x, y) => Rbool (x = y))
            | Concat =>
                 primString2 (fn (x, y) => Rstring (x ^ y))
            | EqString =>
                 primString2 (fn (x, y) => Rbool (x = y))
            | LtString =>
                 primString2 (fn (x, y) => Rbool (x < y))
            | Print =>
                 primString (fn x => (! Printer.printer x; Runit)))

   end
