
signature PRIM_EVAL_PARAM =
   sig

      type result

      exception Wrong

      val Runit : result
      val Rbool : bool -> result
      val Rint : int -> result
      val Rchar : char -> result
      val Rstring : string -> result

      val destRbool : result -> bool option
      val destRint : result -> int option
      val destRchar : result -> char option
      val destRstring : result -> string option

   end


signature PRIM_EVAL =
   sig

      type result

      val primeval : Prim.prim -> result list -> result

   end
