
signature INSPECT =
   sig

      val depth : int ref

      val load : exn -> unit
      val extract : unit -> exn

      val cur : unit -> unit
      val width : unit -> int
      val path : unit -> int list

      val down : int list -> unit
      val down1 : int -> unit
      val up : int -> unit
      val top : unit -> unit

      type state
      val saveState : unit -> state
      val restoreState : state -> unit

      exception Navigation
      exception Extract

   end
