
signature HASH_CONS =
   sig

      type label = word
      type tag

      type 'a table
      type 'a object = 'a * tag

      val table : unit -> 'a table
      val destroyTable : 'a table -> unit

      (* Each constructor must use a distinct label. *)
      val cons0 : 'a table -> label -> 'a -> 'a object
      val cons1 : 'a table -> label -> ('b -> 'a) -> 'b object -> 'a object
      val cons2 : 'a table -> label -> ('b * 'c -> 'a) -> ('b object * 'c object) -> 'a object
      val cons3 : 'a table -> label -> ('b * 'c * 'd -> 'a) -> ('b object * 'c object * 'd object) -> 'a object
      val consList : 'a table -> label -> ('b list -> 'a) -> 'b object list -> 'a object

      val consInt : int -> int object
      val consChar : char -> char object

      val consString : string -> string object
      val destroyStringTable : unit -> unit

   end
