
signature SUBST_CLOSURE =
   sig

      type kind = ILClosure.kind
      type con = ILClosure.con
      type exp = ILClosure.exp
      type value = ILClosure.value
      
      (* For X in {Kind, Con, Exp, Value}:
         substXGen m [s0, .. sn-1] l exp = exp[0 .. m-1 . s0[^m] .. sn-1[^m] . ^l+m]

         For X in {Exp, Value}
         If    d = v0 |-> e0 .. vp-1 |-> ep-1
         then  dsubstXGen m [s0, .. sn-1] l d e
               = [e0[^m] .. ep-1[^m] / v0 .. vp-1] (e[0 .. m-1 . s0[^m] .. sn-1[^m] . ^l+m])
      *)

      val substKindGen : int -> con list -> int -> kind -> kind
      val substConGen : int -> con list -> int -> con -> con
      val substExpGen : int -> con list -> int -> exp -> exp
      val substValueGen : int -> con list -> int -> value -> value
      val dsubstExpGen : int -> con list -> int -> value VariableDict.dict -> exp -> exp
      val dsubstValueGen : int -> con list -> int -> value VariableDict.dict -> value -> value

      val liftKind : int -> kind -> kind
      val liftCon : int -> con -> con
      val liftExp : int -> exp -> exp
      val liftValue : int -> value -> value

      val substKind : con -> kind -> kind
      val substCon : con -> con -> con
      val substExp : con -> exp -> exp
      val substValue : con -> value -> value

   end
