
(* Same as ILCps. *)
structure ILClosure =
   struct

      datatype kind =
         Ktype
       | Ksing of con
       | Kpi of kind * kind     (* binds *)
       | Ksigma of kind * kind  (* binds *)
       | Kunit

      and con =
         Cvar of int * int option
       | Clam of kind * con     (* binds *)
       | Capp of con * con
       | Cpair of con * con
       | Cpi1 of con
       | Cpi2 of con
       | Cunit

       | Cnot of con
       | Cexists of kind * con  (* binds *)
       | Cprod of con list
       | Csum of con list
       | Crec of con            (* binds *)
       | Ctag of con
       | Cref of con
       | Cexn
       | Cbool
       | Cint
       | Cchar
       | Cstring

      type variable = Variable.variable

      datatype exp =
         Eapp of value * value
       | Eunpack of variable * value * exp      (* binds *)
       | Eproj of variable * value * int * exp
       | Ecase of value * (variable * exp) list
       | Eiftag of value * value * variable * exp * exp
       | Enewtag of variable * con * exp
       | Eref of variable * value * exp
       | Ederef of variable * value * exp
       | Eassign of value * value * exp
       | Eif of value * exp * exp
       | Elet of variable * value * exp
       | Eprim of variable * Prim.prim * value list * exp
       | Ehalt

      and value =
         Vvar of variable
       | Vlam of variable * con * exp
       | Vpack of con * value * con
       | Vtuple of value list
       | Vinj of value * int * con
       | Vroll of value * con
       | Vunroll of value
       | Vtag of value * value
       | Vbool of bool
       | Vint of int
       | Vchar of char
       | Vstring of string

   end
