
functor ContextClosureFun (val imposeKind : int -> ILClosure.kind -> ILClosure.kind
                           val imposeCon : int -> ILClosure.con -> ILClosure.con)
   :> CONTEXT_CLOSURE
   =
   struct
   
      open ILClosure

      type variable = Variable.variable

      structure VariableKey =
         struct
            type t = Variable.variable
            val eq = Variable.eq
            val compare = Variable.compare
         end

      structure Dict = SplayDict (structure Key = VariableKey)

      type context =
         { ksize : int, kctx : kind list, tctx : (int * con) Dict.dict }
         (* ksize = |kctx| *)

      val empty = { ksize=0, kctx=[], tctx=Dict.empty }

      fun lookupKind ({ kctx, ...}:context) i =
         (SubstClosure.liftKind (i+1) (List.nth (kctx, i))
          handle Subscript => raise Misc.TypeError)

      fun lookupType ({ ksize, tctx, ...}:context) v =
         let
            val (n, c) =
               Dict.lookup tctx v
               handle Dict.Absent => raise Misc.TypeError
         in
            SubstClosure.liftCon (ksize-n) c
         end

      fun extendKind { ksize, kctx, tctx } k =
         { ksize = ksize+1,
           kctx = imposeKind ksize k :: kctx,
           tctx = tctx }

      fun extendType { ksize, kctx, tctx } v c =
         { ksize = ksize,
           kctx = kctx,
           tctx = Dict.insert tctx v (ksize, imposeCon ksize c) }

      fun eraseTypes { ksize, kctx, tctx } =
         { ksize = ksize,
           kctx = kctx,
           tctx = Dict.empty }

      fun ksize ({ ksize=n, ...}:context) = n

      fun allKinds ({ kctx, ...}:context) = kctx

   end


structure ContextClosure =
   ContextClosureFun
   ((* Replace these with identity functions for better performance but less error checking. *)
    val imposeKind = DebugClosure.imposeKind
    val imposeCon = DebugClosure.imposeCon)
