
structure ILAlloc =
   struct

      type variable = Variable.variable

      datatype value =
         Vvar of variable
       | Vbool of bool
       | Vint of int
       | Vchar of char

      datatype oper =
         Olet of variable * value
       | Oalloc of variable * int
       | Oread of variable * variable * int
       | Owrite of variable * int * value
       | Ostring of variable * string
       | Oprim of variable * Prim.prim * value list
       | Optreq of variable * variable * variable

      datatype exp =
         Edo of oper list * exp
       | Eapp of variable * value
       | Ecase of variable * exp list
       | Eif of variable * exp * exp
       | Ehalt

      datatype program =
         Pbody of exp
       | Pfun of variable * variable * exp * program

   end
