
structure Subst :> SUBST
   =
   struct

      open Syntax

      (* |s| = n *)
      fun substMain m s n l c =
         (case c of
             Cvar i =>
                if i < m then
                   c
                else if i < m+n then
                   substMain 0 [] 0 m (List.nth (s, i-m))
                else
                   Cvar (i-n+l)
           | Clam (k, c1) =>
                Clam (k, substMain (m+1) s n l c1)
           | Capp (c1, c2) =>
                Capp (substMain m s n l c1, substMain m s n l c2)
           | Carrow (c1, c2) =>
                Carrow (substMain m s n l c1, substMain m s n l c2)
           | Cforall (k, c1) =>
                Cforall (k, substMain (m+1) s n l c1))

      fun substGen m s l c =
         let
            val n = length s
         in
            if n = 0 andalso l = 0 then
               c
            else
               substMain m s n l c
         end

      fun lift m c = substMain 0 [] 0 m c
      fun subst s c = substMain 0 [s] 1 0 c

   end
