
signature EQUIV =
   sig

      type kind = Syntax.kind
      type con = Syntax.con

      type context = kind list

      exception TypeError
 
      (* whnf c 

         Suppose  G |- c : k
         Then     return c'
                  where
                  c' is the weak-head normal form of c
      *)
      val whnf : con -> con


      (* equiv G c c' k

         Suppose  G |- c : k
                  G |- c' : k
         Then     if    G |- c <=> c' : k
                  then  return ()
                  else  raise TypeError
      *)
      val equiv : context -> con -> con -> kind -> unit


      (* equivStr G c c'

         Suppose  G |- c : k
                  G |- c' : k
                  c, c' are weak-head-normal forms
         Then     if    G |- c <-> c' : k
                  then  return k
                  else  raise TypeError
      *)
      val equivStr : context -> con -> con -> kind

   end
