#============================================================================
# UTILITIES
#============================================================================
#
# History:
#
# 11sep97 Set *UI* to nil upon exit by exit_proc. [cox]
#
#
#============================================================================

# The return-val function is defined in prod-specific.lisp. The lispVar 
# procedure returns the value of the lisp variable named by vname if it 
# exists; otherwise, it returns the string "NIL"
# 
proc lispVar {vname} {
    lisp_send "(return-val $vname)"
    return [lisp_receive]
}

proc exit_proc {} {  
    lisp_command "(setf *ui* nil)"
    puts "exiting now"
    exit
}


proc odd {num} {
    if {[expr %($num / 2)] == 0} {
	return 1
    } else {
	return 0
    }
}


