;;;
;;; I'll try to set everything up in here.
;;; Things pointed to here will move around and become stable later
;;; on, but this file will always define prod-ui, which will start up
;;; the ui from lisp.
;;;

;;; History 
;;;
;;; 23apr97 Reconciled the code with Jim's UI version that uses the latest
;;; Tcl/Tk [cox] 
;;;
;;; NOTE that changes marked CRH is from Clint Hyde of BBN (Boston).
;;;



(in-package "USER")


(defvar *prod-ui-home* 
  (concatenate 'string 
	       *system-directory*
	       "ui"))

;;;this is new, CRH. 10-2-97.
(load (concatenate 'string *prod-ui-home* "/sockets/c-interface.lisp"))
(load (concatenate 'string *prod-ui-home* "/sockets/socket-interface.lisp"))

(defvar *tcl-customizations* 
  (concatenate 'string 
	       *prod-ui-home*
	       "/example-param-custom.tcl")
  "A string specifying a file with your personal tcl code")

;;; [cox 31oct96]
(defvar *post-tcl-customizations* nil
  "String specifies file with code loaded last that overloads existing code")


(defvar *shell-stream* nil)

;;; Just until working, then I'll move this to afs.
;(defvar *tcl-home* "/usr0/root/")
(defvar *tcl-home* "/afs/cs/project/prodigy-2/tcl-tk/")

;;;commented, for new socket code. CRH, 10-2-97.
;(load (concatenate 'string *prod-ui-home* "/ipc"))
(load (concatenate 'string *prod-ui-home* "/tcl"))

;;; Useful for quick sanity checks
(defun ping () (send-to-tcl "hi"))

;;; Want this loaded up front for the partial order stuff to work
;;; smoothly
#|
(unless (find-package "PSGRAPH") (make-package "PSGRAPH"))
(load "/afs/cs/project/prodigy-aperez/order/access-fns-pro4.lisp")
(load "/afs/cs/project/prodigy-aperez/order/my-release-partial.lisp")
(load "/afs/cs/project/prodigy-aperez/order/process-preconds.lisp")
(load "/afs/cs/project/prodigy-jblythe/tcl-tk/footprint.lisp")
(load "/afs/cs/project/prodigy-aperez/codep4/psgraph.lisp")
(load "/afs/cs/project/prodigy-aperez/codep4/print-partial.lisp"))
|#

(load (concatenate 'string *prod-ui-home* "/prod-specific"))
;Added to implement user control of planning decisions [19sep97 cox]
(load (concatenate 'string *prod-ui-home* "/ask-rules"))
(load (concatenate 'string *prod-ui-home* "/scrollbutton"))
(load (concatenate 'string *prod-ui-home* "/op-graph"))


;;;=================================================
;;; Code for managing the tcl shell from lisp
;;;=================================================

(defvar *send-shell-verbose* nil)

(defun send-shell (string)
  (if *send-shell-verbose*
      (format t "Sending to shell: ~S~%" string))
  (format *shell-stream* string)
  (terpri *shell-stream*)
  (finish-output *shell-stream*))

(defun quit-tcl-shell ()
  (when *shell-stream*
    (send-shell "exit")
    (send-shell "exit")
    (close *shell-stream*)
    (setf *shell-stream* nil)))

;;; Not using -f so that tcl code can be run before the main ui, which
;;; is necessary under the current scheme for adding to the menu windows.
;;;
;;; Added manual-ui switch to allow loading of tcl code from a separate
;;; tcl window if desired (just pass non-nil arg). If so then prod-ui 
;;; will not source the tcl code. [cox 5may97]
;;;
(defun prod-ui (&optional manual-ui)
  (let ((tcl-lib (concatenate 'string *tcl-home* 
			      "lib"
			      ))
	(tcl-bin (concatenate 'string *tcl-home*
;;;			      "bin"
			      "tk4.2/unix"
			      )))
    ;; Create dummy problem-space if none already exists. [cox 28may97]
    (if (not (boundp 
	      '*current-problem-space*))
	(setf *current-problem-space* 
	      (p4::make-problem-space :name 'dummy)))
    (format t "~%Restarting tcl server..")
    (kill-tcl-server :silent t)
    (start-tcl-server t)		; tcl7.5 only supports tcp sockets
    (unless *shell-stream*
	    (setf *shell-stream*
		  (excl:run-shell-command "csh" :wait nil :input :stream)))
    (unless (probe-file (concatenate 'string tcl-bin "/wish"))
	    (setf tcl-lib  *tcl-home*)
	    (setf tcl-bin  *tcl-home*))
    (send-shell (format nil "setenv TCL_LIBRARY \"~Atcl7.6/library\"" 
			*tcl-home* 
;;;			tcl-lib
			))
    (send-shell (format nil "setenv TK_LIBRARY \"~Atk4.2/library\"" tcl-lib))    
    (unless manual-ui
;;;            (send-shell (format 
;;;			 nil "/usr0/jblythe/bin/tkdot -geometry 1x1+0+0" 
;;;			 tcl-bin))
	    (send-shell (format nil "~A/wish -geometry 1x1+0+0" 
				tcl-bin))
	    (sleep 5)
	    (send-shell (format nil 
				"source ~A/ui-start.tcl" 
				*prod-ui-home*
				))
	    (sleep 1)
	    (if *tcl-customizations*
		(send-shell (format nil "source ~A" *tcl-customizations*)))
	    (sleep 1)
	    (send-shell (format nil 
				"source ~A/ui-comm.tcl" 
				*prod-ui-home*)) ;[cox 15dec96]
	    (if *post-tcl-customizations*
		(send-shell (format nil "source ~A" *post-tcl-customizations*)))
	    )
    ;; UI begins in generative mode.
    (setf *analogical-replay* nil)	;[cox 26jan97]
    ))

