;;;

;;; Load all the cases in *case-cache*
(defun load-cases-tcl ()
  (setf *merge-mode* 'saba)
  (dolist (case *case-cache*)
    (fresh-clean-begin-case case)
    (send-to-tcl "Load-case")
    (send-to-tcl (guiding-case-name case))
    (show-case-tcl case)
    (send-to-tcl "Mark-first")
    (send-to-tcl (guiding-case-name case))
    (send-to-tcl 1)
    (send-to-tcl "  ")))

(defun show-case-tcl (case)
  (let ((case-elt (guiding-case-ptr case)))
    (when case-elt
      (cond
       ((case-goal-p case-elt)
	(setf *print-case* :downcase)
	(send-to-tcl
	 (format nil "~A"
		 (get-case-new-visible-goal case-elt case))))
       ((case-operator-p case-elt)
	(setf *print-case* :downcase)
	(send-to-tcl
	 (format nil "~A"
		 (get-case-visible-operator case-elt))))
       ((case-bindings-p case-elt)
	(setf *print-case* :downcase)
	(send-to-tcl
	 (format nil "~A"
		 (nth 1 (get-case-new-visible-bindings case-elt case)))))
       (t
	(send-to-tcl
	 (get-case-new-visible-inst-op case-elt case))))
      (advance-ptr case)
      (show-case-tcl case))))

;; Clean everything
(defun unmark-case (case-name)
  (send-to-tcl "Unmark-case")
  (send-to-tcl case-name))


;; Send to SaveCase the values of case-file-name and case-directory-name

(defun get-default-case-names ()
  (setf *case-directory* (or *case-directory*
			     (concatenate 'string *problem-path*
					  "/probs/cases/"))
	*case-file* (or *case-file*
			(concatenate 'string "case-"
				     (string-downcase
				      (symbol-name
				       (p4::problem-name
					(current-problem)))))))
  (send-to-tcl "case-file-name")
  (send-to-tcl *case-file*)
  (send-to-tcl "case-directory-name")
  (send-to-tcl *case-directory*))

