#!/afs/cs/project/theo-7/tcl-tk/bin/dpwish -f

set ui_home /afs/cs/project/prodigy/version4.0/working/system/ui

source $ui_home/tolisp.tcl

start_up_connection


set boldfont  -adobe-times-medium-r-normal--*-140-*
set basefont  -adobe-times-medium-r-normal--*-140-*
set obliquefont  -adobe-times-medium-i-normal--*-140-*

set TabCase ""
set PointerCase ""
set w 0

proc ReceiveCase {} {
    global lisp TabCase PointerCase w cur_win 
    global win

    set line [gets $lisp]
    set TabCase [linsert $TabCase [llength $TabCase] $line]
    set PointerCase [linsert $PointerCase [llength $PointerCase] 0]
    set cur_win $w
    incr w    

    set win .w$cur_win

    toplevel $win
    wm geometry $win +55+400
    wm title $win Case:

    message $win.prompt -font -Adobe-times-medium-i-normal--*-140* -aspect 300 \
	    -text [lindex $TabCase $cur_win]
    pack $win.prompt

    frame $win.but -bd 1
    pack  $win.but -expand 1 -fill x

    button $win.but.close -text Close  -width 12 -command {destroy [selection own]}
    pack $win.but.close -expand 1 -fill x
}

set k 0

proc EnterCaseElt {line} {
    global win k cur_win

    set win .w$cur_win

    frame $win.$k
    pack  $win.$k

    label $win.$k.name -text $line -bd 1 -relief sunken 
    pack  $win.$k.name -side left -expand 1
                 
    set status($k) ""
    label $win.$k.mark -text $status($k) -width 5
    pack  $win.$k.mark -side left
    incr k
}

proc RunLoop { } {
    global lisp 
    set line [gets $lisp]

    while {$line != "DONE"} {
        if {$line == "Update-case"} {
            puts "Received Update-case from Lisp"
            UpdateCaseElement
            update idletasks
    	    set line [gets $lisp]
        }
    }
}

proc UpdateCaseElement { } {
    global lisp TabCase PointerCase
    
    set case_name [gets $lisp]
    set case_elt [gets $lisp]
    set case_message [gets $lisp]

    set pos [lsearch -exact $TabCase $case_name]
    set cur_pointer_pos [lindex $PointerCase $pos]
    set PointerCase [lreplace $PointerCase $pos $pos $case_elt]

    destroy .w$pos.$case_elt.mark
    if {$cur_pointer_pos != 0} {
        destroy .w$pos.$cur_pointer_pos.mark
    }

    label .w$pos.$case_elt.mark -text "<==" -width 5
    pack  .w$pos.$case_elt.mark

    if {$cur_pointer_pos != 0} {
        label .w$pos.$cur_pointer_pos.mark -text "**" -width 5
        pack  .w$pos.$cur_pointer_pos.mark
    }
}

proc ProcessCases {} {
    global lisp cur_win
    puts "...waiting for lisp...."

    set line [gets $lisp]
    while {$line != "DONE"} {
        if {[string compare $line "Load-case"] == 0} {
    	    puts "Received Load-case from Lisp"
	    ReceiveCase
            puts "Writing now in window $cur_win"
    	    update idletasks
        } else {
    	    EnterCaseElt $line
	    puts stdout "Got line $line"
        }
    set line [gets $lisp]
    }
}

wm withdraw .
ProcessCases
#RunLoop
