;;;***************************************************************************
;;;
;;; History:
;;;
;;; 12sep97 Created setup2.lisp to replace setup.lisp. Difference is that the
;;;         Development subdirectory that contains the x-analogy code is now
;;;         considered a full-fledged part of the analogy code. It is now
;;;         listed as an analogy module in *analogy-modules*. The separate code
;;;         to load interpreted x-analogy code has been removed. It is now
;;;         compiled along with the rest and loaded as binaries. [cox]
;;;


;;; Setup of path to analogy source and compiled files
(defparameter *analogy-pathname* "/afs/cs/project/prodigy-1/analogy/")
(defparameter *analogy-binary-pathname*
  (concatenate 'string *analogy-pathname*
               #+APPLE "fasl:"
               #+(and CMU IBM-RT-PC) ".ibm-rt/"
               #+(and ALLEGRO SUN3 ALLEGRO-V3.1)  ".sun3-allegro-3.1/"
               #+(and ALLEGRO DEC3100 ALLEGRO-V3.1) ".pmax-allegro/"
               #+(and ALLEGRO DEC3100 ALLEGRO-V4.1) ".pmax-allegro-4.1/"
               #+(and CMU PMAX) ".pmax-cmu/"
               #+(and ALLEGRO SPARC ALLEGRO-V4.2) ".sparc-allegro-4.2/"
               #+(and ALLEGRO SPARC ALLEGRO-V4.1) ".sparc-allegro-4.1/"
               #+(and ALLEGRO SPARC ALLEGRO-V4.0) ".sparc-allegro-4.0/"
               #+(and ALLEGRO SPARC ALLEGRO-V3.1) ".sparc-allegro-3.1/"
               #+(and CMU SPARC) ".sparc-cmu/"
               #+(and DOS CLISP) "dosbin/"
               #+PA ".hp-9000/"
               #+(and PRISM ALLEGRO-V4.2) ".hp-allegro-4.2/"
               #+(and LUCID LCL4.0 MIPS) ".pmax-lucid-4.0/"
               #+(and LUCID LCL4.0 SPARC) ".sparc-lucid-4.0/"
               ))
(defparameter *binary-extension*
  #+APPLE "fasl"
  #+IBM-RT-PC "fasl"
  #+(and ALLEGRO SUN3) "fasl"
  #+(and ALLEGRO DEC3100) "decf"
  #+(and ALLEGRO RS6000) "fasl"
  #+(and CMU PMAX) "pmaxf"
  #+(and (not LUCID) SPARC) "fasl"
  #+DOS "fas"
  #+(and LUCID SPARC) "sbin"
  #+(and LUCID MIPS) "mbin")

;;;***************************************************************************
;;; Defines the files to be loaded for analogy 
;;; Some extra code is needed for the analogy control rules.
;;; The extra printing code is just here because I like this way of showing
;;; the alternatives at the applied op level.

(defparameter *analogy-modules*
  '(("prodigy-extras/"  "operator-inf-rule" "binding-ctrl-rules"
                        "my-comforts" "print-current-search-path")
    ("storage/"   "case-structures" "access-case" "store" "save-case"
                  "footprint" "print-rules" "preconds")
    ("loading/"   "load-cases" "load-case-headers")
    ("replay/"    "newest-replay" "interrupt-replay")
    ("retrieval/" "manual-retrieval" "retrieve-test")
    ("tcl/" "load-cases-tcl")
    ("Development/"  "loadtrace" "x-retrieval" "x-replay" 
                     "x-step" "x-analogy-support" "x-merge-eval")
   ))

;;;***************************************************************************
;;; Different functions to load and compile analogy

(defun load-analogy-source ()
  (dolist (module *analogy-modules*)
    (dolist (file (cdr module))
      (load (concatenate 'string *analogy-pathname* (car module) file))))
  (setf *analogy-loaded* t))

(defun analogy-compile-all ()
  (dolist (module *analogy-modules*)
    (dolist (file (cdr module))
      (compile-file
       (concatenate 'string *analogy-pathname* (car module) file)
       :output-file
       (concatenate 'string *analogy-binary-pathname* file
		    "." *binary-extension*)))))

(defun load-analogy ()
  (let ((old-print-case *print-case*))
    (dolist (module *analogy-modules*)
      (let ((ender (concatenate 'string "." *binary-extension*))
	    (*load-verbose* t))
	(dolist (file (cdr module))
	  ;;(format t "~%Loading ~S"  (concatenate 'string *analogy-binary-pathname* file ender))
	  (load (concatenate 'string *analogy-binary-pathname* file ender)))))
    (setf *analogy-loaded* t)
    (setf *print-case* old-print-case)))


;;;***************************************************************************
(defvar *load-analogy-immediately* t)


;;;***************************************************************************
;;; Other settings
(setf *class-short-names* nil)

(setf *automated-retrieval* nil
      *analogical-replay* nil
      *a-star-search* nil
      *weaver-search* nil
      *talk-case-p* t
      *always-remove-p* t
      p4::*print-search-path-p* t
      *ui* nil)

(setf p4::*compile-tests* nil)
(setf p4::*use-new-matcher* nil)

(clear-prod-handlers)

;;;***************************************************************************
;;; Only makes sense to call after load-analogy was called.

(defun set-for-replay ()
  (clear-prod-handlers) ;;not sure what is the effect of this in other handlers.
  (define-prod-handler :always #'link-to-case-prodigy-node)

  (setf *automated-retrieval* nil
	*analogical-replay* t
	*a-star-search* nil
	*weaver-search* nil
	*talk-case-p* t
	*merge-mode* 'saba
	*ui* nil))

;;; Don't forget that the control rules for replay need to be loaded with
;;; the domain. The rules are in /afs/cs/project/prodigy-1/analogy/replay-crs.lisp
;;;***************************************************************************

(defun set-for-replay-ui ()
  (setf *ui* t))


(if *load-analogy-immediately*
    (load-analogy)			;Load binaries
  (load-analogy-source))

(format t "~%;;; Prodigy-Analogy is loaded.~%~%")


(set-for-replay)




