/*
 * icompat.h
 * Purpose: Handle integer type size compatibility.
 */

/*
 * Copyright (C) 1994	Visual Understanding Systems
 *  All rights reserved world wide.
 */

/* 
 * Revision history:
 * 94/05/11    Richard Nash nash@visus.com
 *   Created
*/

#ifndef _ICOMPAT_H
#define _ICOMPAT_H

/*
 * This header file centralizes the integer size compatibility issues. A
 * program should almost never use char, short, int, long, or long long because
 * it can't be sure how many bits long each of these types are. There are some
 * cases when such use is unavoidable, system calls being one. Instead declare
 * the storage you need by using the below defined types.
 * 
 * Edit this file by adding an #if block for your system type (which needs
 * to be defined somewhere, preferable with -DSYSTEM_FOOBAR on the compiler's
 * command line) so that the typedefs and constants meet this definition:
 *
 * Each of these types is assumed to be packed and addressable in
 * memory on any 8 bit boundary.
 *
 * Type     Range
 * int8     [-128 to 127]
 * int16    [-32768 to 32767]
 * int32    [-2147483648 to 2147483647]
 * int64    [-9223372036854775808 to 9223372036854775807]
 * uint8    [0 to 255]
 * uint16   [0 to 65535]
 * uint32   [0 to 4294967295]
 * uint64   [0 to 18446744073709551615]
 *
 * Also define the CHARSIZE, SHORTSIZE, INTSIZE, LONGSIZE, and LONGLONGSIZE
 * macros to be the number of bits in a 'char', 'short', 'int', 'long', and
 * 'long long' respectively. This is needed since many system calls expect
 * these types and conversions may need to be done.
 *
 * If you are unable to do any of this on your system, all is not lost. For
 * example, if you can't get the 64 bit types to work, then just remove the
 * references to them. If the program that uses this header doesn't make
 * use of those types, then you are okay. Of course, if it does, it is probably
 * for a good reason. Then you should be aware that there may be problems in
 * the integer operations in this program is suspect to problems. You have
 * been warned.
 */

/*#ifdef SYSTEM_DECALPHA*/
#ifdef __alpha
#include <malloc.h>
#include <stdlib.h>

#ifndef _NO_COMPAT_TYPES_
typedef char int8;
typedef short int16;
typedef int int32;
typedef long int64;

typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned int uint32;
typedef unsigned long uint64;
#endif

#define MININT8 (int8)-128
#define MAXINT8 (int8)127
#define MININT16 (int16)-32768
#define MAXINT16 (int16)32767
#define MININT32 (int32)-2147483648L
#define MAXINT32 (int32)2147483647L
#define MININT64 (int64)-9223372036854775808LL
#define MAXINT64 (int64)9223372036854775807LL

#define MAXUINT8 (uint8)255
#define MAXUINT16 (uint16)65535
#define MAXUINT32 (uint32)4294967295L
#define MAXUINT64 (uint64)18446744073709551615LL

#define CHARSIZE 8
#define SHORTSIZE 16
#define INTSIZE 32
#define LONGSIZE 64
#define LONGLONGSIZE 64

#else /* __alpha */
/* __MWERKS__ ==> MetroWerks for Mac compiler */
#ifdef __MWERKS__

#ifndef _NO_COMPAT_TYPES_
typedef char int8;
typedef short int16;
typedef long int32;

typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned long uint32;
#endif


#define MININT8 (int8)-128
#define MAXINT8 (int8)127
#define MININT16 (int16)-32768
#define MAXINT16 (int16)32767
#define MININT32 (int32)-2147483648L
#define MAXINT32 (int32)2147483647L

#define MAXUINT8 (uint8)255
#define MAXUINT16 (uint16)65535
#define MAXUINT32 (uint32)4294967295L

#define CHARSIZE 8
#define SHORTSIZE 16
#define INTSIZE 32
#define LONGSIZE 32

#else /* __MWERKS__ */
/* The default definitions. These work for the GNU compiler under
 * Nextstep 3.2 and probably on most machines with 32-bit data registers
 */
#include <malloc.h>
#include <stdlib.h>


#ifndef _NO_COMPAT_TYPES_
typedef char int8;
typedef short int16;
typedef long int32;
typedef long long int64;

typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned long uint32;
typedef unsigned long long uint64;
#endif

#define MININT8 (int8)-128
#define MAXINT8 (int8)127
#define MININT16 (int16)-32768
#define MAXINT16 (int16)32767
#define MININT32 (int32)-2147483648L
#define MAXINT32 (int32)2147483647L
#define MININT64 (int64)-9223372036854775808LL
#define MAXINT64 (int64)9223372036854775807LL

#define MAXUINT8 (uint8)255
#define MAXUINT16 (uint16)65535
#define MAXUINT32 (uint32)4294967295L
#define MAXUINT64 (uint64)18446744073709551615LL

#define CHARSIZE 8
#define SHORTSIZE 16
#define INTSIZE 32
#define LONGSIZE 32
#define LONGLONGSIZE 64

#endif /* __MWERKS__ */
#endif /* __alpha    */


/* Define the Boolean type */
typedef unsigned char bool;
#ifndef TRUE
#define TRUE ((bool)1)
#endif
#ifndef FALSE
#define FALSE ((bool)0)
#endif
#ifndef YES
#define YES TRUE
#endif
#ifndef NO
#define NO FALSE
#endif
#define BoolCast(i) (((i) == 0) ? FALSE : TRUE)

#endif /*_ICOMPAT_H*/
