/*
 **     Copyright (C) 1995  Rick Romero and Carnegie Mellon University
 **
 **     This program is free software; you can redistribute it and/or modify
 **     it under the terms of the GNU General Public License as published by
 **     the Free Software Foundation; either version 1, or (at your option)
 **     any later version.
 **     
 **     This program is distributed in the hope that it will be useful,
 **     but WITHOUT ANY WARRANTY; without even the implied warranty of
 **     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **     GNU General Public License for more details.
 **     
 **     You should have received a copy of the GNU General Public License
 **     along with this program; if not, write to the Free Software
 **     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _DKDTREE_H_
#define _DKDTREE_H_

#include <math.h>

#include <icompat.h>
#include "splaylib.h"


#define DKD_DIMENSIONS 4
#define LOWER_NODES_MIN 20

#ifdef DEBUG
extern int rebalance_counts;
extern int rebuild_counts;
extern int inserts;
extern int deletes;
#endif


typedef int32 dkd_vector[DKD_DIMENSIONS];


typedef struct _dkd_tree_ {
  SplayTree_p stree;
  int32      dimensions;
  int32      points, nodes;
  int32      inserts, deletes, maxmods;
  int32      uppernodes, lowernodes;
} DKDTree_t, *DKDTree_p;


typedef struct _dkd_node_ {
  SplayTree_p stree;
  int32      dimensions;   /* dimension of sub-tree rooted here      */
  int32      points;       /* total points rooted at sub-tree        */
  int32      nodes;        /* Number of actual Splay nodes           */
  int32      inserts;      /* number of nodes inserted               */
  int32      deletes;      /* number of nodes deleted                */
  int32      maxnodes;     /* max number of splay nodes allowed      */
  int32      maxpoints;    /* total allowed points in sub-tree       */
  int32      left, right;  /* spatial extents of this tree           */
} DKDNode_t, *DKDNode_p;


typedef struct _dkd_obj_list_ {
  void *object;
  struct _dkd_obj_list_ *next;
} DKDObjList_t, *DKDObjList_p;

  
typedef struct _dkd_leaf_ {
  dkd_vector location;
  DKDObjList_t obj_list;      /* List of objects at this location        */
} DKDLeaf_t, *DKDLeaf_p;

typedef struct _dkd_leaf_list_ DKDLeafList_t, *DKDLeafList_p;

DKDTree_p CreateDKDTree(int dimensions);
void      DKDInsert(DKDTree_p, dkd_vector, void *);
DKDLeaf_p DKDCreateLeaf();
void      DKDFreeLeaf(DKDLeaf_p);
int       DKDDelete(DKDTree_p, dkd_vector, DKDObjList_p);
DKDLeaf_p DKDAccess(DKDTree_p, DKDLeaf_p);
void      DKDDestroyTree(DKDTree_p);

#endif


