/*
 * Copyright (c) 1991 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator   or   Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie the rights
 * to redistribute these changes.
 */
/*
 * varargs versions of printf routines
 *
 **********************************************************************
 * HISTORY
 * 13-Oct-93  Mary Thompson (mrt) at Carnegie-Mellon University
 *	Changes for alpha and AIX
 *	from Franz Fischer.
 *
 * $Log:	vprintf.c,v $
 * Revision 2.9  93/10/09  17:34:24  mja
 * 	Use _ptr rather than _cnt to compute remaining length in vsnprintf() since
 * 	the RT _doprnt() uses fwrite() in some cases and it doesn't update _cnt
 * 	when attempting to write beyond the end of the buffer.
 * 	[93/10/09  17:34:12  mja]
 * 
 * Revision 2.5  89/09/08  18:15:55  mbj
 * 	Use _doprnt() for the Multimax (an "old" architecture).
 * 	[89/09/08            mbj]
 * 
 * Revision 2.4  89/08/03  14:40:10  mja
 * 	Add vsnprintf() routine.
 * 	[89/07/12            mja]
 * 
 * 	Terminate vsprintf() string with null byte.
 * 	[89/04/21            mja]
 * 
 * 	Change to use new hidden name for _doprnt on MIPS.
 * 	[89/04/18            mja]
 * 
 * Revision 2.3  89/06/10  14:13:43  gm0w
 * 	Added putc of NULL byte to vsprintf.
 * 	[89/06/10            gm0w]
 * 
 * Revision 2.2  88/12/13  13:53:17  gm0w
 * 	From Brad White.
 * 	[88/12/13            gm0w]
 ************************************************************
 */

#include <stdio.h>
#include <varargs.h>

#define MAXS 32767

#ifdef DOPRINT_VA
/* 
 *  system provides _doprnt_va routine
 */
#define	_doprnt	_doprnt_va
#else
/*
 * system provides _doprnt routine
 */
#define _doprnt_va _doprnt
#endif

#ifndef _AIX
int
vprintf(fmt, args)
	char *fmt;
	va_list args;
{
	_doprnt(fmt, args, stdout);
	return (ferror(stdout) ? EOF : 0);
}

int
vfprintf(f, fmt, args)
	FILE *f;
	char *fmt;
	va_list args;
{
	_doprnt(fmt, args, f);
	return (ferror(f) ? EOF : 0);
}

int
vsprintf(s, fmt, args)
	char *s, *fmt;
	va_list args;
{
	FILE fakebuf;

	fakebuf._flag = _IOSTRG+_IOWRT;	/* no _IOWRT: avoid stdio bug */
	fakebuf._ptr = (unsigned char *)s;
	fakebuf._cnt = MAXS;
	_doprnt(fmt, args, &fakebuf);
	putc('\0', &fakebuf);
	return (strlen(s));
}

int
vsnprintf(s, n, fmt, args)
	char *s, *fmt;
	int n;
	va_list args;
{
	FILE fakebuf;

	fakebuf._flag = _IOSTRG+_IOWRT;	/* no _IOWRT: avoid stdio bug */
	fakebuf._ptr = (unsigned char *)s;
	fakebuf._cnt = n-1;
	_doprnt(fmt, args, &fakebuf);
	fakebuf._cnt = n-((long)fakebuf._ptr-(long)s);
	if (fakebuf._cnt > 0)		 /* paranoia */
	    putc('\0', &fakebuf);
	if (fakebuf._cnt<0)
	    fakebuf._cnt = 0;
	return (n-fakebuf._cnt-1);
}
#else /* _AIX */
   /* AIX supplies other routines but not vsnprintf */
vsnprintf(s, n, fmt, args)
	char *s, *fmt;
	int n;
	va_list args;
{
	char s1[MAXS];

	if ( n > MAXS) {
		fprintf(stderr,"String too long for vsnfprintf() \n");
		return (n);
	}
	vsprintf(s1, fmt, args);
	strncpy(s, s1, n);
	return (strlen(s));
 }
#endif /* _AIX */
