/*
 * Mach Operating System
 * Copyright (c) 1993 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	gprof_support2.c,v $
 * Revision 2.2  93/08/11  14:32:54  mrt
 * 	Additional code for profiling library
 * 	[93/08/06            bershad]
 * 
 *
 * File:	gprof_support2.c
 * Author:	Brian Bershad
 * Date:	July 1993
 *
 *	This is stuff that will not easily run (link) w/both UX and apps.
 *
 */


#include <mach.h>
#include <mach/pc_sample.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/kernel.h>
#include <cthreads.h>
#include <stdio.h>
#include "gprof.h"

extern cthread_t gprof_sample_thread;
static cthread_t gprof_server_thread;

extern int gprof_do_profiling;
extern int gprof_debug;



int gprof_ux_server = FALSE;	/* externed in gprof_support to pull this in */

int (*gprof_get_export_pid)();	/* to override default (my) pid setting */
char *gprof_gmon_out;		/* set to override default prof file name*/


int
gprof_stop(filename)
    char *filename;
{
    char *mon_data;
    int  mon_data_cnt;
    int off, size, result;
    int fd;
    int turnoff;
    kern_return_t krc;

#define WRITE_SIZE_LIMIT 4096

    if (gprof_sample_thread == NO_CTHREAD)
      return (KERN_FAILURE);

    /* turn off sampling */
    turnoff = 0;
    krc = do_gprof_mon_switch(MACH_PORT_NULL, &turnoff);
    if (krc != KERN_SUCCESS) return (krc);

    /* obtain pc sampling data */
    krc = do_gprof_mon_dump(MACH_PORT_NULL, &mon_data, &mon_data_cnt);
    if (krc != KERN_SUCCESS) return (krc);

    if (!filename)  {
	filename = "gmon.out";
    }

    if (gprof_debug)
	    printf("Writing %d bytes to file \"%s\"\n", mon_data_cnt, filename);

    /* write file */
    fd = creat(filename, 0666);
    if (fd < 0) return (KERN_FAILURE);

    for (off = 0; off < mon_data_cnt; off += WRITE_SIZE_LIMIT) {
      size = mon_data_cnt - off; 
      if (size > WRITE_SIZE_LIMIT) size = WRITE_SIZE_LIMIT;
      result = write (fd, &mon_data[off], size);
      if (result != size) {
	printf("Write of file \"%s\" failed, rc=%d\n", filename, result);
	break;
      }
    }
    close(fd);

    return (KERN_SUCCESS);
}


gprof_start(sample_flavor)
    sampled_pc_flavor_t *sample_flavor;
{
    return do_gprof_mon_switch(MACH_PORT_NULL, sample_flavor);
}



    
/*
 * gprof server initialization. Only activated if not in UX.
 */

static mach_port_t gprof_control_server_port;

static void*
gprof_control_server_loop(any)
    void *any;
{
    kern_return_t krc;
    extern void gprof_control_server();

    
    if (gprof_ux_server)	
	printf("Warning: gprof_control_server_loop used in UX\n");

    krc = mach_msg_server(gprof_control_server,
			  8192, gprof_control_server_port);
    mach_error("gprof_control_server_init mach_msg_server returns", krc);
}



kern_return_t
gprof_control_server_init()
{
    kern_return_t krc;
    char namebuf[128];
    int	pid;

    
    if (gprof_ux_server)	
	printf("Warning: gprof_control_server_init used in UX\n");

    if (gprof_control_server_port != MACH_PORT_NULL)  {
	return KERN_SUCCESS;
    }

    krc = mach_port_allocate(mach_task_self(), MACH_PORT_RIGHT_RECEIVE,
			     &gprof_control_server_port);
    if (krc != KERN_SUCCESS)  {
	mach_error("gprof_control_server_init port_allocate", krc);
	return krc;
    }

    krc = mach_port_insert_right(mach_task_self(),
				 gprof_control_server_port,
				 gprof_control_server_port,
				 MACH_MSG_TYPE_MAKE_SEND);
    if (krc != KERN_SUCCESS)  {
	mach_error("gprof_control_server_init port_insert_right", krc);
	return krc;
    }

    if (gprof_get_export_pid)  {
	pid = (*gprof_get_export_pid)();
    } else {
	pid = getpid();
    }
    sprintf(namebuf,"gprof.%d", pid);
    
    krc = netname_check_in(name_server_port,
			   namebuf, MACH_PORT_NULL,
			   gprof_control_server_port);
    if (krc != KERN_SUCCESS)  {
	mach_error("gprof_control_server_init netname_check_in", krc);
	return krc;
    }

    if (gprof_debug) 
	fprintf(stderr,"NETNAME CHECKED IN: %s %d\n", namebuf, krc);

    gprof_server_thread = cthread_fork(gprof_control_server_loop, 0);

    return krc;

}


/*
 * These routines are null, but provided to allow user code to link
 * against gprof_support
 */

timeout(a,b,c)
{
	printf("bad timeout\n");
}

untimeout(a,b,c)
{
	printf("bad untimeout\n");
}

/*
 * CRT0 support routines
 */
void monstartup_crt0();
void (*_monstartup_routine)() = monstartup_crt0;		/* for crt0 */
int gprof_no_startup_from_crt0;    /* set to TRUE for no default profiling */
int gprof_no_control_server;      /* set to TRUE for no control server*/
int gprof_no_auto_initialization_from_crt0;	/* set to TRUE to eliminate monstartup */

void
monshutdown_crt0()
{
    if (gprof_ux_server)  {
	gprof_warning("monshutdown_crt0 called\n");
	return;
    }
    if (gprof_do_profiling)  {
	gprof_stop(gprof_gmon_out);
    }
}

void
monstartup_crt0()
{
    int flavor = SAMPLED_PC_PERIODIC;

    if (gprof_no_auto_initialization_from_crt0)
    	return;
    
    if (gprof_ux_server)  {
	/* can't initialize until whole system is initialized */
    	return;
    } else {
	atexit(monshutdown_crt0);
	if (!gprof_no_control_server)  {
	    gprof_control_server_init();
	}
	monstartup();
	if (!gprof_no_startup_from_crt0)  {
	    gprof_start(&flavor);
	}
    }
}



	
    
