/* 
 * Mach Operating System
 * Copyright (c) 1991,1990,1989 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS 
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	logo_setup.c,v $
 * Revision 2.2  93/05/31  16:04:05  mrt
 * 	RCS-ed.
 * 	[93/05/08            af]
 * 
 */
/*
 * Copyright (C) 1990 Regents of the University of California.
 * Permission to use, copy, and distribute verbatim copies of this
 * software and its documentation for any purpose and without fee is
 * hereby granted, provided that the above copyright notice appears in all
 * copies.  Permission is granted to copy and distribute modified versions
 * of this software under the conditions for verbatim copying, provided
 * that the entire resulting derived work is distributed under the terms
 * of a permission notice identical to this one.  The University of
 * California makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Xaw/Form.h>
# include <X11/Xaw/Label.h>
# include <X11/Xaw/Toggle.h>
# include <X11/Xaw/Scrollbar.h>

# include <math.h>
# include <stdio.h>

# include "cdrom_globs.h"
# include "cdrom_callb.h"

# include "logo.xbm"

# define MAXVOL		0xff

static Widget	track_button_widget;
static Widget	timer_label_widget;
static Widget	volume_scroll_widget;

static int	vol;

void
logo_setup(parent_widget)
	Widget		parent_widget;
{
	extern void	cb_track_button();
	extern void	leds_label_setup();
	void		volume_jump_proc();
	void		volume_scroll_proc();
	Widget		logo_form_widget;
	Widget		logo_label_widget;
	Pixmap		logo_label_pixmap;
	Arg		args[1];

	logo_form_widget = XtCreateManagedWidget("logoForm", formWidgetClass,
						 parent_widget,
						 (ArgList) NULL, 0);

	logo_label_widget = XtCreateManagedWidget("logoLabel",
						  labelWidgetClass,
						  logo_form_widget,
						  (ArgList) NULL, 0);

	logo_label_pixmap = XCreateBitmapFromData(XtDisplay(logo_label_widget),
						  rootwin(logo_label_widget),
						  logo_bits,
						  logo_width, logo_height);

	XtSetArg(args[0], XtNbitmap, logo_label_pixmap);
	XtSetValues(logo_label_widget, args, 1);

	leds_label_setup(logo_form_widget);

	track_button_widget = XtCreateManagedWidget("trackButton",
						    toggleWidgetClass,
						    logo_form_widget,
						    (ArgList) NULL, 0);

	XtAddCallback(track_button_widget, XtNcallback, cb_track_button, 0);

	track_button_update();

	if (display_timer == True)
		timer_label_widget = XtCreateManagedWidget("timerLabel",
							   labelWidgetClass,
							   logo_form_widget,
							   (ArgList) NULL, 0);

	timer_label_update();

	volume_scroll_widget = XtCreateManagedWidget("volumeScrollbar",
						     scrollbarWidgetClass,
						     logo_form_widget,
						     (ArgList) NULL, 0);

	XtAddCallback(volume_scroll_widget, XtNjumpProc, volume_jump_proc, 0);
	XtAddCallback(volume_scroll_widget, XtNscrollProc,
		      volume_scroll_proc, 0);

	vol = MAXVOL;
	XawScrollbarSetThumb(volume_scroll_widget, (float) 1.0, (float) -1.0);
}

/*ARGSUSED*/
static void
cb_track_button(widget, client_data, call_data)
	Widget		widget;
	XtPointer	client_data;
	XtPointer	call_data;
{
	char		track_buf[40];
	Arg		args[1];
	Boolean		state;

	XtSetArg(args[0], XtNstate, &state);
	XtGetValues(widget, args, 1);

	if (state == True)
		sprintf(track_buf, "%d\n", cdi.cdi_maxtrack);
	else
		sprintf(track_buf, "%d\n", cdi.cdi_curtrack);

	XtSetArg(args[0], XtNlabel, track_buf);
	XtSetValues(widget, args, 1);
}

void
track_button_update() {
	char		track_buf[40];
	Arg		args[1];

	sprintf(track_buf, "%d\n", cdi.cdi_curtrack);

	XtSetArg(args[0], XtNlabel, track_buf);
	XtSetValues(track_button_widget, args, 1);
}

void
timer_label_update() {
	char		timer_buf[40];
	Arg		args[1];

	if (display_timer == False)
		return;

	sprintf(timer_buf, "%02u:%02u\n", cdi.cdi_dur / 60, cdi.cdi_dur % 60);

	XtSetArg(args[0], XtNlabel, timer_buf);
	XtSetValues(timer_label_widget, args, 1);
}

static void
volume_jump_proc(scroll_widget, client_data, percent)
	Widget		scroll_widget;
	XtPointer	client_data;
	XtPointer	percent;
{
	vol = (*(float *) percent) * MAXVOL;

# if defined(notdef)
	vol = pow((double) vol, (double) volbase);

	if (volbase > 1.0)
		vol += ((2 * MAXVOL) - (volbase * MAXVOL)) / 2;
# endif /* defined(notdef) */

	if (vol > MAXVOL)
		vol = MAXVOL;
	if (vol <= 0)
		vol = 1;

	debug_printf(1, "volume=%u\n", (unsigned int) vol);

	cdrom_volume(vol, vol);
}

static void
volume_scroll_proc(scroll_widget, client_data, position)
	Widget		scroll_widget;
	XtPointer	client_data;
	XtPointer	position;
{
	Arg		args[1];
	Dimension	length;
	float		top;
	double		abspos;
	double		percent;
	double		vdelta;

	if ((abspos = (int) position) < 0)
		abspos = -abspos;

	XtSetArg(args[0], XtNlength, &length);
	XtGetValues(scroll_widget, args, 1);

	if (length <= 0)
		length = 1;

	percent = abspos / (float) length;

	if ((vdelta = (vol * percent)) < 1.0)
		vdelta = 1.0;

	vdelta /= 10.0;

	if ((int) position < 0)
		vol += vdelta;
	else
		vol -= vdelta;

# if defined(notdef)
	vol *= volbase;
# endif /* defined(notdef) */

	if (vol > MAXVOL)
		vol = MAXVOL;
	if (vol <= 0)
		vol = 1;

	cdrom_volume(vol, vol);

	top = (double) vol / (double) MAXVOL;

	XawScrollbarSetThumb(volume_scroll_widget, (float) top, (float) -1.0);
}
