/* 
 * Mach Operating System
 * Copyright (c) 1991,1990,1989 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS 
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	leds.c,v $
 * Revision 2.2  93/05/31  16:03:58  mrt
 * 	RCS-ed.
 * 	[93/05/08            af]
 * 
 */
/*
 * Copyright (C) 1990 Regents of the University of California.
 * Permission to use, copy, and distribute verbatim copies of this
 * software and its documentation for any purpose and without fee is
 * hereby granted, provided that the above copyright notice appears in all
 * copies.  Permission is granted to copy and distribute modified versions
 * of this software under the conditions for verbatim copying, provided
 * that the entire resulting derived work is distributed under the terms
 * of a permission notice identical to this one.  The University of
 * California makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Xaw/Label.h>

# include "cdrom_globs.h"

# include "circle0a.xbm"
# include "circle0b.xbm"
# include "circle0c.xbm"
# include "circle0d.xbm"
# include "circle0e.xbm"
# include "circle0f.xbm"
# include "circle0g.xbm"
# include "circle0h.xbm"
# include "circle00.xbm"

static Widget	leds_label_widget;

# define NUM_LEDS	8

static Pixmap	leds_pixmaps[NUM_LEDS];
static Pixmap	leds_pixmap;

void
leds_update() {
	static int	ctr;
	Arg		args[1];
	Pixmap		leds;

	leds = leds_pixmaps[ctr++ % NUM_LEDS];

	XtSetArg(args[0], XtNbitmap, (XtArgVal) leds);
	XtSetValues(leds_label_widget, args, 1);
}

void
leds_stop() {
	Arg		args[1];

	XtSetArg(args[0], XtNbitmap, (XtArgVal) leds_pixmap);
	XtSetValues(leds_label_widget, args, 1);
}

void
leds_label_setup(parent_widget)
	Widget		parent_widget;
{
	Arg		args[1];

	leds_label_widget = XtCreateManagedWidget("ledsLabel",
						  labelWidgetClass,
						  parent_widget,
						  (ArgList) NULL, 0);

	leds_pixmaps[0] = XCreateBitmapFromData(XtDisplay(leds_label_widget),
						rootwin(leds_label_widget),
						circle0a_bits,
						circle0a_width, circle0a_height);
	leds_pixmaps[1] = XCreateBitmapFromData(XtDisplay(leds_label_widget),
						rootwin(leds_label_widget),
						circle0b_bits,
						circle0b_width, circle0b_height);
	leds_pixmaps[2] = XCreateBitmapFromData(XtDisplay(leds_label_widget),
						rootwin(leds_label_widget),
						circle0c_bits,
						circle0c_width, circle0c_height);
	leds_pixmaps[3] = XCreateBitmapFromData(XtDisplay(leds_label_widget),
						rootwin(leds_label_widget),
						circle0d_bits,
						circle0d_width, circle0d_height);
	leds_pixmaps[4] = XCreateBitmapFromData(XtDisplay(leds_label_widget),
						rootwin(leds_label_widget),
						circle0e_bits,
						circle0e_width, circle0e_height);
	leds_pixmaps[5] = XCreateBitmapFromData(XtDisplay(leds_label_widget),
						rootwin(leds_label_widget),
						circle0f_bits,
						circle0f_width, circle0f_height);
	leds_pixmaps[6] = XCreateBitmapFromData(XtDisplay(leds_label_widget),
						rootwin(leds_label_widget),
						circle0g_bits,
						circle0g_width, circle0g_height);
	leds_pixmaps[7] = XCreateBitmapFromData(XtDisplay(leds_label_widget),
						rootwin(leds_label_widget),
						circle0h_bits,
						circle0h_width, circle0h_height);

	leds_pixmap = XCreateBitmapFromData(XtDisplay(leds_label_widget),
					     rootwin(leds_label_widget),
					     circle00_bits,
					     circle00_width, circle00_height);

	XtSetArg(args[0], XtNbitmap, (XtArgVal) leds_pixmap);
	XtSetValues(leds_label_widget, args, 1);
}
