.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	vm_inherit.man,v $
.\" Revision 2.5  93/03/18  15:16:44  mrt
.\" 	corrected types
.\" 	[93/03/12  16:55:19  lli]
.\" 
.\" Revision 2.4  91/05/14  17:15:36  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:16:14  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:17:10  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:47:30  rpd
.\" 	Created.
.\" 
.TH vm_inherit 2 9/19/86
.CM 4
.SH NAME
.nf
vm_inherit  \-  specifies inheritence of address space 
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t vm_inherit(target_task, address, size, new_inheritance)
	mach_port_t	target_task;
	vm_address_t	address;
	vm_size_t	size;
	vm_inherit_t	new_inheritance;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_task
Task whose virtual memory is to be affected.
.TP 15
.B
address
Starting address (will be rounded down to a page
boundary). 
.TP 15
.B
size
Size in bytes of the region for which inheritance is to change
(will be rounded up to give a page boundary).
.TP 15
.B
new_inheritance
How this memory is to be inherited in child tasks.  
Inheritance is specified by using one of these following three values:
.TP 15
.B
VM_INHERIT_SHARE
Child tasks will share this memory with this task.
.TP 15
.B
VM_INHERIT_COPY
Child tasks will receive a copy of this region.
.TP 15
.B
VM_INHERIT_NONE
This region will be absent from child tasks.

.SH DESCRIPTION
.B vm_inherit
specifies how a region of a task's address space
is to be passed to child tasks at the time of task creation.
Inheritance is an attribute of virtual pages, thus the addresses
and size of memory to be set will be rounded out to refer to
whole pages.

Setting 
.B vm_inherit
to 
.B VM_INHERIT_SHARE
and forking a child
task is the only way two Mach 
.B tasks
can share physical memory.
Remember that all the 
.B theads
of a given task share all the same
memory.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
Memory protected.
.TP 25
KERN_INVALID_ADDRESS
Illegal address specified.

.SH SEE ALSO
.B task_create, vm_regions

