.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	thread_terminate.man,v $
.\" Revision 2.5  93/03/18  15:16:31  mrt
.\" 	corrected types
.\" 	[93/03/12  16:55:06  lli]
.\" 
.\" Revision 2.4  91/05/14  17:15:03  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:15:52  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:16:47  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:47:01  rpd
.\" 	Created.
.\" 
.TH thread_terminate 2 9/19/86
.CM 4
.SH NAME
.nf
thread_terminate  \-  destroys specified thread
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t thread_terminate(target_thread)
	mach_port_t	target_thread;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_thread
The thread to be destroyed.

.SH DESCRIPTION
.B thread_terminate
destroys the thread specified by 
.B target_thread
.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The thread has been killed.
.TP 25
KERN_INVALID_ARGUMENT
.B target_thread
is not a thread.

.SH SEE ALSO
.B task_terminate, task_threads, thread_create,
.B thread_resume, thread_suspend



