.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_port_set_seqno.man,v $
.\" Revision 2.3  93/05/10  19:31:50  rvb
.\" 	updated
.\" 	[93/04/21  16:04:05  lli]
.\" 
.\" Revision 2.2  91/12/11  08:43:23  jsb
.\" 	Created.
.\" 	[91/11/25            rpd]
.\" 
.TH mach_port_set_seqno 2 1/13/87
.CM 4
.SH NAME
.nf
mach_port_set_seqno \- changes the sequence number of a port
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

kern_return_t
mach_port_set_seqno(task, name, seqno)
	mach_port_t task;
	mach_port_t name;
	mach_port_seqno_t seqno;
.fi
.ft P
.SH ARGUMENTS
.TP 12
.B
task
The task owning the receive right.
.TP 12
.B
name
\fBtask\fR's name for the receive right.
.TP 12
.B
seqno
The sequence number for the next message received from the port.
.SH DESCRIPTION
\fBmach_port_set_seqno\fR changes a port's sequence number.
The specified \fBtask\fR must hold a receive right
(named \fBname\fR) for the port.

All sequence number values are valid.
The next message received from the port will be stamped
with the specified sequence number.
.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_TASK
\fBtask\fR was invalid.
.TP 25
KERN_INVALID_NAME
\fBname\fR did not denote a right.
.TP 25
KERN_INVALID_RIGHT
\fBname\fR denoted a right, but not a receive right.
.PP
The \fBmach_port_set_seqno\fR call is actually an RPC to \fBtask\fR,
normally a send right for a task port, but potentially any send right.
In addition to the normal diagnostic
return codes from the call's server (normally the kernel),
the call may return \fBmach_msg(2)\fR return codes.
.SH SEE ALSO
mach_port_get_receive_status(2).
