(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (Edoardo.Biagioni@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Ken Cline (Kenneth.Cline@cs.cmu.edu)
        Nick Haines (Nick.Haines@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15213-3891

		i.	Abstract

        WORD signature for Fox (probably temporary).


		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature FOXWORD


		1.	signature FOXWORD
*)

signature FOXWORD =
 sig
  eqtype word
  val + : word * word -> word
  val - : word * word -> word
  val * : word * word -> word
  val div: word * word -> word
  val mod: word * word -> word
  val andb: word * word -> word
  val orb: word * word -> word
  val xorb: word * word -> word
  val notb: word -> word
  val min: word * word -> word
  val max: word * word -> word
  val << : word * Word.word -> word
  val >> : word * Word.word -> word
  val ~>> : word * Word.word -> word
  val < : word * word -> bool
  val <= : word * word -> bool
  val > : word * word -> bool
  val >= : word * word -> bool
  val fromInt: int -> word
  val fromLargeWord : Word32.word -> word
  val toInt: word -> int
  val toIntX: word -> int
  val toLargeWord : word -> Word32.word
  val toLargeWordX : word -> Word32.word
  val fromString : string -> word option
  val toString : word -> string

  val bigEndian: bool

  val sub: Word8Array.array * int -> word
  val sub_big: Word8Array.array * int -> word
  val sub_little: Word8Array.array * int -> word

  val subv: Word8Vector.vector * int -> word
  val subv_big: Word8Vector.vector * int -> word
  val subv_little: Word8Vector.vector * int -> word

  val update: Word8Array.array * int * word -> unit
  val update_big: Word8Array.array * int * word -> unit
  val update_little: Word8Array.array * int * word -> unit
 end
