(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Nick Haines  (Nick.Haines@cs.cmu.edu)
	Edoardo Biagioni <Edoardo.Biagioni@cs.cmu.edu>
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract
	store.sig: signature STORE. A store is used to store and
	retrieve objects based on keys, which must support the 
	equality operator.

		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature STORE


		1.	signature STORE
*)

signature STORE =
 sig
  type ('key, 'value) T		(* the type of the store itself *)

  (* create a new store with no elements. *)
  val new: ('key -> word) * ('key * 'key -> bool) -> ('key, 'value) T
  val size: ('key, 'value) T -> int
  val empty: ('key, 'value) T -> bool

  (* add a "key, element" pair *)
  val add: ('key, 'value) T * 'key * 'value -> ('key, 'value) T

  exception Not_Present_In_Store (* raised by find if the key is not present *)
  val find: ('key, 'value) T * 'key -> (('key, 'value) T * 'value)

  (* like find, but returns NONE if the key is not present.
   * if SOME is returned, we return a new store which may be optimized
   * for searching this value *)
  val look: ('key, 'value) T * 'key -> (('key, 'value) T * 'value) option

  (* no-op if key not present *)
  val remove: ('key, 'value) T * 'key -> ('key, 'value) T

  (* remove those elements for which the predicate returns true. *)
  val remove_selected: ('key, 'value) T * ('key * 'value -> bool)
                     -> ('key, 'value) T

  (* map and fold are defined by analogy with the list operations *)
  val map: ('key * 'a -> 'b) -> ('key, 'a) T -> ('key, 'b) T

  val fold: (('key * 'a) * 'b -> 'b) -> ('key, 'a) T -> 'b -> 'b

  val makestring: ('key, 'value) T * (('key * 'value) -> string)
                * string (* separator *) -> string

 end
