(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (Edoardo.Biagioni@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Ken Cline (Kenneth.Cline@cs.cmu.edu)
        Nick Haines (Nick.Haines@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	A functor for building udp over ip over eth over ethdev.


		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	functor Build_Udp


		1.	functor Build_Udp
*)

functor Build_Udp (structure Device: DEVICE_PROTOCOL
		   sharing type Device.Incoming.T = Device.Outgoing.T
		   structure B: FOX_BASIS
		   val udp_over_ip: Word8.word
		   val eth_debug_level: int ref option
		   val arp_debug_level: int ref option
		   val ip_debug_level: int ref option
		   val udp_debug_level: int ref option): UDP_STACK =
 struct

  local
   val ip_protocol = Word16.fromInt 0x800
   val icmp_protocol = 0wx1 : Word8.word

   structure Lower = Build_Ip (structure Device = Device
			       structure B = B
			       val icmp_protocol = icmp_protocol
			       val ip_protocol = ip_protocol
			       val eth_debug_level = eth_debug_level
			       val arp_debug_level = arp_debug_level
			       val ip_debug_level = ip_debug_level)
  in 
   open Lower
  end

  structure Udp = Udp (structure Lower = Ip
		       structure B = B
		       val udp_over_ip = udp_over_ip
		       val compute_checksums = false
		       val debug_level = udp_debug_level)

 end (* struct *)
