(*

        FoxNet: The Fox Project's Communication Protocol Implementation Effort
        Edo Biagioni (esb@cs.cmu.edu)
        Nick Haines (nickh@cs.cmu.edu)
        Brian Milnes (milnes@cs.cmu.edu)
        Fox Project
        School of Computer Science
        Carnegie Mellon University
        Pittsburgh, Pa 15139-3891

		i.	Abstract
	tcplog.sig: signature for logging of the TCP implementation


		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature TCP_LOG


	1.	signature TCP_LOG

	for debugging purposes it is useful to know the significant
	events in a TCP's history without significantly slowing down
	the TCP itself. Stats keeping and event logging can be turned
	on with the corresponding control operations, and the results
	read with the corresponding info commands. Logging is off when
	a connection is first opened and by default.
*)

signature TCP_LOG =
 sig

  datatype tcp_stats = Tcp_Stats of {bytes_sent: unit -> Word64.word,
				     bytes_received: unit -> Word64.word,
				     packets_sent: Word64.word,
				     packets_received: Word64.word,
				     packets_resent: Word64.word,
				     bad_packets_received: Word64.word}
            
  val stats_string: tcp_stats -> string

  type time

  datatype tcp_event =
       Retransmit of {size: int}
     | Congestion_Window_Change of {new_size: int, old_size: int}
     | Round_Trip_Time_Change of {new_rtt: time, old_rtt: time,
				  new_rto: time, old_rto: time}
     | Bad_Packet_Received
     | Packet_Sent of {size: int, window: int,
		       seq: Word32.word, ack: Word32.word}
     | Packet_Received of {size: int, window: int,
			   seq: Word32.word, ack: Word32.word}
     | Empty_Sent of {window: int, seq: Word32.word, ack: Word32.word}
     | Empty_Received of {window: int, seq: Word32.word,
			  ack: Word32.word}

  val event_makestring: tcp_event -> string

  val event_string: time * tcp_event -> string

  (* relative_time makes time relative to the first time in the list. *)
  val relative_time: (time * tcp_event) list ->
                     (time * tcp_event) list

 end (* sig *)
